<?php
  // Uruchamianie sesji.
  require_once('startsession.php');

  // Wstawianie nagłówka strony.
  $page_title = 'Kwestionariusz';
  require_once('header.php');

  require_once('appvars.php');
  require_once('connectvars.php');

  // Przed przejściem do dalszych operacji należy się upewnić, że użytkownik jest zalogowany.
  if (!isset($_SESSION['user_id'])) {
    echo '<p class="login"><a href="login.php">Zaloguj się</a>, aby uzyskać dostęp do strony.</p>';
    exit();
  }

  // Wyświetlanie menu nawigacyjnego.
  require_once('navmenu.php');

  // Łączenie się z bazą danych.
  $dbc = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

  // Jeśli użytkownik nie wypełnił formularza, należy wstawić puste odpowiedzi do bazy.
  $query = "SELECT * FROM mismatch_response WHERE user_id = '" . $_SESSION['user_id'] . "'";
  $data = mysqli_query($dbc, $query);
  if (mysqli_num_rows($data) == 0) {
    // Najpierw należy pobrać listę identyfikatorów tematów z tabeli mismatch_topic.
    $query = "SELECT topic_id FROM mismatch_topic ORDER BY category_id, topic_id";
    $data = mysqli_query($dbc, $query);
    $topicIDs = array();
    while ($row = mysqli_fetch_array($data)) {
      array_push($topicIDs, $row['topic_id']);
    }

    // Wstawianie do tabeli mismatch_response pustych wierszy odpowiedzi (po jednym na temat).
    foreach ($topicIDs as $topic_id) {
      $query = "INSERT INTO mismatch_response (user_id, topic_id) VALUES ('" . $_SESSION['user_id']. "', '$topic_id')";
      mysqli_query($dbc, $query);
    }
  }

  // Jeśli użytkownik przesłał formularz z kwestionariuszem, należy zapisać oceny w bazie.
  if (isset($_POST['submit'])) {
    // Zapisywanie wierszy z ocenami z kwestionariusza w tabeli mismatch_response.
    foreach ($_POST as $response_id => $response) {
      $query = "UPDATE mismatch_response SET response = '$response' WHERE response_id = '$response_id'";
      mysqli_query($dbc, $query);
    }
    echo '<p>Odpowiedzi zostały zapisane.</p>';
  }

  // Pobieranie z bazy danych związanych z odpowiedzią w celu wygenerowania formularza.
  $query = "SELECT response_id, topic_id, response FROM mismatch_response WHERE user_id = '" . $_SESSION['user_id'] . "'";
  $data = mysqli_query($dbc, $query);
  $responses = array();
  while ($row = mysqli_fetch_array($data)) {
    // Sprawdzanie nazwy tematu w tabeli mismatch_topic.
    $query2 = "SELECT name, category FROM mismatch_topic WHERE topic_id = '" . $row['topic_id'] . "'";
    $data2 = mysqli_query($dbc, $query2);
    if (mysqli_num_rows($data2) == 1) {
      $row2 = mysqli_fetch_array($data2);
      $row['topic_name'] = $row2['name'];
      $row['category_name'] = $row2['category'];
      array_push($responses, $row);
    }
  }

  mysqli_close($dbc);

  // Generowanie formularza z kwestionariuszem przez przejście w pętli po 
  // tablicy z odpowiedziami. 
  echo '<form method="post" action="' . $_SERVER['PHP_SELF'] . '">';
  echo '<p>Co myślisz o każdym z tych tematów?</p>';
  $category = $responses[0]['category_name'];
  echo '<fieldset><legend>' . $responses[0]['category_name'] . '</legend>';
  foreach ($responses as $response) {
    // Nowy znacznik grupy należy otworzyć tylko po zmianie kategorii.
    if ($category != $response['category_name']) {
      $category = $response['category_name'];
      echo '</fieldset><fieldset><legend>' . $response['category_name'] . '</legend>';
    }

    // Wyświetlanie pola tematu w formularzu.
    echo '<label ' . ($response['response'] == NULL ? 'class="error"' : '') . ' for="' . $response['response_id'] . '">' . $response['topic_name'] . ':</label>';
    echo '<input type="radio" id="' . $response['response_id'] . '" name="' . $response['response_id'] . '" value="1" ' . ($response['response'] == 1 ? 'checked="checked"' : '') . ' />Lubię ';
    echo '<input type="radio" id="' . $response['response_id'] . '" name="' . $response['response_id'] . '" value="2" ' . ($response['response'] == 2 ? 'checked="checked"' : '') . ' />Nie lubię<br />';
  }
  echo '</fieldset>';
  echo '<input type="submit" value="Zapisz odpowiedzi" name="submit" />';
  echo '</form>';

  // Wstawianie stopki strony.
  require_once('footer.php');
?>
