<?php
  session_start();

  // Ustawianie ważnych stałych na potrzeby testu CAPTCHA.
  define('CAPTCHA_NUMCHARS', 6); // Liczba znaków w haśle.
  define('CAPTCHA_WIDTH', 100); // Szerokość rysunku.
  define('CAPTCHA_HEIGHT', 25); // Wysokość rysunku.

  // Generowanie losowego hasła.
  $pass_phrase = "";
  for ($i = 0; $i < CAPTCHA_NUMCHARS; $i++) {
    $pass_phrase .= chr(rand(97, 122));
  }

  // Zapisywanie zaszyfrowanego hasła w zmiennej sesji.
  $_SESSION['pass_phrase'] = SHA1($pass_phrase);

  // Tworzenie rysunku.
  $img = imagecreatetruecolor(CAPTCHA_WIDTH, CAPTCHA_HEIGHT);

  // Ustawianie białego tła z czarnym tekstem i szarymi elementami graficznymi.
  $bg_color = imagecolorallocate($img, 255, 255, 255); // Biały.
  $text_color = imagecolorallocate($img, 0, 0, 0); // Czarny.
  $graphic_color = imagecolorallocate($img, 64, 64, 64); // Ciemnoszary.

  // Wypełnianie tła.
  imagefilledrectangle($img, 0, 0, CAPTCHA_WIDTH, CAPTCHA_HEIGHT, $bg_color);

  // Rysowanie losowo rozmieszczonych linii. 
  for ($i = 0; $i < 5; $i++) {
    imageline($img, 0, rand() % CAPTCHA_HEIGHT, CAPTCHA_WIDTH, rand() % CAPTCHA_HEIGHT, $graphic_color);
  }

  // Dodawanie losowo rozmieszczonych kropek.
  for ($i = 0; $i < 50; $i++) {
    imagesetpixel($img, rand() % CAPTCHA_WIDTH, rand() % CAPTCHA_HEIGHT, $graphic_color);
  }

  // Wyświetlanie tekstu hasła.
  imagettftext($img, 18, 0, 5, CAPTCHA_HEIGHT - 5, $text_color, 'Courier New Bold.ttf', $pass_phrase);

  // Przesyłanie rysunku jako pliku PNG za pomocą nagłówka.
  header("Content-type: image/png");
  imagepng($img);

  // Operacje porządkujące.
  imagedestroy($img);
?>
