
import java.io.*;
import java.util.*;

public class SubwayPrinter
{
    private PrintStream out;
    
    public SubwayPrinter(OutputStream out) {
        this.out = new PrintStream(out);
    }
    
    public void printDirections(List route) {
        Connection connection = (Connection) route.get(0);
        String currentLine = connection.getLineName();
        String previousLine = currentLine;
        
        out.println("Zaczynamy od stacji " + connection.getStation2().getName() + ".");
        out.println("Jed lini " + currentLine + " w kierunku stacji " + connection.getStation2().getName() + ".");
        
        for (int i = 1; i < route.size(); i++) {
            connection = (Connection) route.get(i);
            currentLine = connection.getLineName();
            if (currentLine.equals(previousLine)) {
                out.println("  Kontunuujc jazd, mi stacj " + connection.getStation1().getName() + "...");
            }
            else {
                out.println("Kiedy dojedziesz do stacji " + connection.getStation1().getName() + ", wysid z pocigu linii " + previousLine + ".");
                out.println("Nastpnie jed lini " + currentLine + ", w kierunku stacji " + connection.getStation2().getName() + ".");
                previousLine = currentLine;
            }
        }
        out.println("Wysid z metra na stacji " + connection.getStation2().getName() + " i baw si dobrze!");
    }
}
