
import junit.framework.TestCase;


public class UnitTester extends TestCase
{
    public void testType(Unit unit, String type, String expectedOutputType) {
        System.out.println("\nTestowanie zapisu i odczytu waciwoci 'type'.");
        unit.setType(type);
        String outputType = unit.getType();
        if (expectedOutputType.equals(outputType))
        {
            System.out.println("Test zkoczony pomylnie");
        }
        else
        {
      		System.out.println("Nie udao si pomylnie przej testu: wartoci " + 
           		outputType + " oraz " + expectedOutputType + " nie odpowiadaj sobie");
        }
    }
    
    public void testUnitSpecificProperty(Unit unit, String propertyName, Object inputValue, Object expectedOutputValue) {
        System.out.println("\nTestowanie zapisu i odczytu waciwoci charakterystycznej dla jednostki.");
        unit.setProperty(propertyName, inputValue);
        Object outputValue = unit.getProperty(propertyName);
        if (expectedOutputValue.equals(outputValue))
        {
            System.out.println("Test zkoczony pomylnie");
        }
        else
        {
      		System.out.println("Nie udao si pomylnie przej testu: wartoci " + 
           		outputValue + " oraz " + expectedOutputValue + " nie odpowiadaj sobie");
        }
    }
    
    
  	public void testChangeProperty(Unit unit, String propertyName, Object inputValue, Object expectedOutputValue) {
    	System.out.println("\nTestowanie zmiany wartoci istniejcej waciwoci jednostki.");
    	unit.setProperty(propertyName, inputValue); 
    	Object outputValue = unit.getProperty(propertyName);
    	if (expectedOutputValue.equals(outputValue)) {
      		System.out.println("Test zkoczony pomylnie");
    	} else {
      		System.out.println("Nie udao si pomylnie przej testu: wartoci " + 
           		outputValue + " oraz " + expectedOutputValue + " nie odpowiadaj sobie");
    	}
  	}
    
    
    public void testNonExistentProperty(Unit unit, String propertyName) {
        System.out.println("\nTestowanie odczytu wartoci nieistniejcej waciwoci.");
        Object outputValue = unit.getProperty(propertyName);
        if (outputValue == null)
        {
            System.out.println("Test zkoczony pomylnie");
        }
        else
        {
            System.out.println("Nie udao si pomylnie przej testu: odczytano warto " + outputValue);
        }
    }
    
    public static void main(String args[]) {
        UnitTester tester = new UnitTester();
        Unit unit = new Unit(1000);
        tester.testType(unit, "piechota", "piechota");
        tester.testUnitSpecificProperty(unit, "hitPoints", new Integer(25), new Integer(25));
        tester.testNonExistentProperty(unit, "strength");
    }
}
