function DebugConsole() {
  // Tworzymy obszar konsoli
  var consoleElem = document.createElement("div");
  consoleElem.id = "debug";
  consoleElem.style.fontFamily = "monospace";
  consoleElem.style.color = "#333333";
  document.body.appendChild(consoleElem);
  consoleElem.appendChild(document.createElement("hr"));

  // Tworzymy zmieniającą się cyklicznie właściwość koloru tła
  this.shaded = false;
}

DebugConsole.prototype.displayMsg = function(msg) {
  // Tworzymy komunikat
  var msgElement = document.createElement("div");
  msgElement.appendChild(document.createTextNode(msg));
  msgElement.style.backgroundColor = this.shaded ? "#EEEEEE" : "#FFFFFF";
  var consoleElem = document.getElementById("debug");
  consoleElem.appendChild(msgElement);

  // Zmieniamy wartość właściwości koloru tła
  this.shaded = !this.shaded;
}
