import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.*;
import java.io.*;

public class KwizGra {

  private JTextArea pytanie;
  private JTextArea odpowiedz;
  private ArrayList tablicaKart;
  private KartaKwizowa biezacaKarta;
  private Iterator iteratorKarty;
  private JFrame ramka;
  private JButton przyciskNastepnaKarta;
  private boolean czyPrezentowanaOdpowiedz;

  public static void main (String[] args) {
    KwizGra gra = new KwizGra();
    gra.doDziela();
  }
    
  public void doDziela() {

    ramka = new JFrame("Kwiz");
    ramka.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    JPanel panelGlowny = new JPanel();
    Font czcionkaDuza = new Font("sanserif", Font.BOLD, 24);

    pytanie = new JTextArea(9,20);
    pytanie.setFont(czcionkaDuza);
    pytanie.setLineWrap(true);
    pytanie.setWrapStyleWord(true);
    pytanie.setEditable(false);
   
    JScrollPane przewijanieP = new JScrollPane(pytanie);
    przewijanieP.setVerticalScrollBarPolicy(
          ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
    przewijanieP.setHorizontalScrollBarPolicy(
          ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
  
    przyciskNastepnaKarta = new JButton("Poka pytanie");
    
    panelGlowny.add(przewijanieP);
    panelGlowny.add(przyciskNastepnaKarta);
    przyciskNastepnaKarta.addActionListener(new NextCardListener());
    JMenuBar pasekMenu = new JMenuBar();
    JMenu menuPlik = new JMenu("Plik");
    
    JMenuItem opcjaOtworz = new JMenuItem("Otwrz zbir kart");
        
    opcjaOtworz.addActionListener(new OtworzMenuListener());
        
    menuPlik.add(opcjaOtworz);
    
    pasekMenu.add(menuPlik);
    ramka.setJMenuBar(pasekMenu);

    ramka.getContentPane().add(BorderLayout.CENTER, panelGlowny);
    ramka.setSize(500,600);
    ramka.setVisible(true);        
  } // koniec metody


  public class NextCardListener implements ActionListener {
    public void actionPerformed(ActionEvent zd) {
      if (czyPrezentowanaOdpowiedz) {
        // poka odpowied bo uytkownik ju widzia pytanie
        pytanie.setText(biezacaKarta.getAnswer());
        przyciskNastepnaKarta.setText("Nastpna karta");
        czyPrezentowanaOdpowiedz = false;
      } else {
        // poka nastpne pytanie
        if (iteratorKarty.hasNext()) {
            
          pokazNastepnaKarte();
            
        } else {
          // nie ma wicej kart
          pytanie.setText("To bya ostatnia karta");
          przyciskNastepnaKarta.setEnabled(false);
        }
      } // koniec if
    } // koniec metody
  } // koniec klasy wewntrznej

  
   public class OtworzMenuListener implements ActionListener {
     public void actionPerformed(ActionEvent ev) {
       JFileChooser dialogFile = new JFileChooser();
       dialogFile.showOpenDialog(ramka);
       wczytajPlik(dialogFile.getSelectedFile());
     }
   }

   private void wczytajPlik(File file) {
     tablicaKart = new ArrayList();
     try {
      BufferedReader czytelnik = new BufferedReader(new FileReader(file));
      String wiersz = null;
      while ((wiersz = czytelnik.readLine()) != null) {
        tworzKarte(wiersz);
      }
      czytelnik.close();

    } catch(Exception ex) {
      System.out.println("Nie mona odczyta pliku");
      ex.printStackTrace();
    }

    // czas zaczyna
    iteratorKarty = tablicaKart.iterator();
    pokazNastepnaKarte();
  }

  private void tworzKarte(String wierszDanych) {
   
    StringTokenizer analizator = new StringTokenizer(wierszDanych, "/");
    if (analizator.hasMoreTokens()) {
      KartaKwizowa card = new KartaKwizowa(analizator.nextToken(), analizator.nextToken());
      tablicaKart.add(card);
    }
  }

  private void pokazNastepnaKarte() {
    biezacaKarta = (KartaKwizowa) iteratorKarty.next();
    pytanie.setText(biezacaKarta.getQuestion());
    przyciskNastepnaKarta.setText("Poka odpowied");
    czyPrezentowanaOdpowiedz = true;
  }
} // koniec klasy
      



