import java.util.*;
public class PortalGraMax {

  private PomocnikGry pomocnik = new PomocnikGry();
  private ArrayList listaPortali = new ArrayList(); 
  private int iloscRuchow = 0; 

  private void przygotujGre() {   
    // najpierw tworzymy portale i okrelamy ich pooenie
    Portal pierwszy = new Portal();
    pierwszy.setNazwa("onet.pl");
    Portal drugi = new Portal();
    drugi.setNazwa("wp.com");
    Portal trzeci = new Portal();
    trzeci.setNazwa("Go2.com");
    listaPortali.add(pierwszy);
    listaPortali.add(drugi);
    listaPortali.add(trzeci);

    System.out.println("Twoim celem jest zatopienie trzech portali.");
    System.out.println("onet.pl, wp.pl, Go2.com");
    System.out.println("Postaraj si je zatopi w jak najmniejszej iloci ruchw.");
     
    for (int i = 0; i < listaPortali.size(); i++) {   
      ArrayList nowePolozenie = pomocnik.rozmiescPortal(3);
      Portal rozmieszczanyPortal = (Portal) listaPortali.get(i);
      rozmieszczanyPortal.okreslPolaPolozenia(nowePolozenie);
    } // koniec ptli for
  } // koniec metody

  private void rozpocznijGre() { 
    while(!listaPortali.isEmpty()) {
      String ruchGracza = pomocnik.pobierzDaneWejsciowe("Podaj pole:"); 
      sprawdzRuchGracza(ruchGracza);
    } // koniec while
    zakonczGre();
  } // koniec metody

  private void sprawdzRuchGracza(String ruch) {
    iloscRuchow++;
    String wynik  = "pudo"; // pocztkow zakadamy e gracz spudowa
    for (int i = 0; i < listaPortali.size(); i++) {
      Portal dotComToTest = (Portal) listaPortali.get(i);
      wynik = dotComToTest.sprawdz(ruch);           
      if (wynik.equals("trafiony")) {
        break;
      }
      if (wynik.equals("zatopiony")) {
        listaPortali.remove(i); // ju po nim !
        break;
      }  
    } // koniec ptli for
    System.out.println(wynik);
  }

  private void zakonczGre() {
    System.out.println("Wszystkie Portale zostay zatopione! Teraz Twoje informacje nie maj znaczenia.");
    if (iloscRuchow <= 18) {
      System.out.println("Wykonae jedynie " + iloscRuchow + " ruchw.");
      System.out.println("Wydostae si, zanim Twoje informacje zatony.");
    } else {
      System.out.println("Ale si grzebae! Wykonae a "+ iloscRuchow + " ruchw.");
      System.out.println("Teraz rybki pywaj pomidzy Twoimi informacjami.");
    }
  }  // koniec metody
   
  
  public static void main (String[] args) {
    PortalGraMax gra = new PortalGraMax();
    gra.przygotujGre();
    gra.rozpocznijGre();
  }
}
