package headfirst;

import javax.ejb.*;
import java.security.*;
import javax.sql.*;
import javax.naming.*;
import java.sql.*;

public abstract class CustomerBean implements EntityBean {

   private EntityContext context;
   private double customerDiscount;
   
   public String ejbCreate(String last, String first, String addr, String ID) throws CreateException {
     System.out.println("in create");
     this.setLast(last);
     this.setFirst(first);
     this.setPK(ID);
     this.setCustAddress(addr);
     this.setLimit(2000.00);
     System.out.println("finishing create");
     return null;        
   }

  public void ejbPostCreate(String last, String first, String addr, String ID) throws CreateException {
     System.out.println("in ejbPostCreate");
  }

   public String getLastName() {
      return this.getLast();
   }

   public void setLastName(String name) {
      this.setLast(name);
   }

   public String getFirstName() {
      return this.getFirst();
   }

   public void setFirstName(String name) {
      this.setFirst(name);
   }  

   public String getAddress() {
      return this.getCustAddress();
   }

   public void setAddress(String addr) {
      this.setCustAddress(addr);
   }   

   public double getCreditLimit() {
      return this.getLimit();
   }

   public void setCreditLimit(double amt) {
      this.setLimit(amt);
   }
   
   public void setEntityContext(EntityContext ctx) {
      context = ctx;
   }

   public abstract String getLast();
   public abstract void setLast(String last);
   public abstract String getFirst();
   public abstract void setFirst(String first);
   public abstract String getCustAddress();
   public abstract void setCustAddress(String addr);
   public abstract String getPK();
   public abstract void setPK(String pk);
   public abstract double getLimit();
   public abstract void setLimit(double amt);

   public void unsetEntityContext() { }
   public void ejbLoad() { }
   public void ejbStore() { }
   public void ejbActivate() { }
   public void ejbPassivate() { }
   public void ejbRemove() { }

   public void doLookup() {
      try {
        InitialContext ic = new InitialContext();
        DataSource ds =  (DataSource) ic.lookup("java:comp/env/jdbc/CustomerDB");
        Connection conn = ds.getConnection();
      } catch (Exception ex) {
         ex.printStackTrace();
      }
  }

public void doEnvLookup() {
      try {
        InitialContext ic = new InitialContext();
        Double dbl =  (Double) ic.lookup("java:comp/env/custDiscount");
        customerDiscount = dbl.doubleValue();
        // use the primitive double value to calculate the discount

      } catch (Exception ex) {
         ex.printStackTrace();
      }
  }

 

}
    

