window.onload = initPage;

var frequencyTable = new Array(
  "a", "a", "a", "a", "a", "ą", "b", "b", "c", "c", "c", "c", "c", "ć", "ć", 
  "d", "d", "d", "d", "e", "e", "e", "e", "e", "e", "ę", "f", "g", "h", "i", 
  "i", "i", "i", "i", "i", "j", "j", "k", "k", "k", "k", "l", "l", "l", "ł", 
  "m", "m", "m", "n", "n", "n", "n", "n", "ń", "o", "o", "o", "o", "o", "o", 
  "o", "ó", "p", "p", "p", "r", "r", "r", "r", "r", "s", "s", "s", "s", "s", 
  "ś", "t", "t", "t", "t", "u", "u", "w", "w", "w", "w", "w", "y", "y", "y", 
  "y", "z", "z", "z", "z", "z", "z", "z", "ź", "ż");

function initPage() {
  randomizeTiles();
  var submitDiv = document.getElementById("submit");
  var a = submitDiv.firstChild;
  while (a.nodeName == "#text") {
    a = a.nextSibling;
  }
  a.onclick = function() { 
    alert("Proszę klikać płytki w celu utworzenia słowa."); 
  }
}

function randomizeTiles() {
  var tiles = document.getElementById("letterbox").getElementsByTagName("a");
  for (i = 0; i < tiles.length; i++) {
    var index = Math.floor(Math.random() * 100);
    var letter = frequencyTable[index];
    tiles[i].className = tiles[i].className + ' l' + letter;
    tiles[i].onclick = addLetter;
  }
}

function addLetter() {
  var tileClasses = this.className.split(" ");
  var letterClass = tileClasses[2];
  var tileLetter = letterClass.substring(1,2);

  var currentWordDiv = document.getElementById("currentWord");
  if (currentWordDiv.childNodes.length == 0) {
    var p = document.createElement("p");
    currentWordDiv.appendChild(p);
    var letterText = document.createTextNode(tileLetter);
    p.appendChild(letterText);
    var submitDiv = document.getElementById("submit");
    var a = submitDiv.firstChild;
    while (a.nodeName == "#text") { 
      a = a.nextSibling;
    }
    a.onclick = submitWord;
  } else {
    var p = currentWordDiv.firstChild;
    var letterText = p.firstChild;
    letterText.nodeValue += tileLetter;
  }

  this.className += " disabled";
  this.onclick = "";
}

function submitWord() {
  var request = createRequest();
  if (request == null) {
    alert ("Nie można utworzyć obiektu żądania.");
    return;
  }
  var currentWordDiv = document.getElementById("currentWord");
  var userWord = currentWordDiv.firstChild.firstChild.nodeValue;
  var url = "dictionary.php?word=" + encodeURIComponent(userWord);
  request.open("GET", url, false);
  request.send(null);

  if (request.responseText == -1) {
    alert("Wpisane słowo jest nieprawidłowe. Spróbuj ponownie!");
  } else {
    var wordListDiv = document.getElementById("wordList");
    var p = document.createElement("p");
    var newWord = document.createTextNode(userWord);
    p.appendChild(newWord);
    wordListDiv.appendChild(p);

    var scoreDiv = document.getElementById("score");
    var scoreNode = scoreDiv.firstChild;
    var scoreText = scoreNode.nodeValue;
    var pieces = scoreText.split(" ");
    var currentScore = parseInt(pieces[1]);
    currentScore += parseInt(request.responseText);
    scoreNode.nodeValue = "Wynik: " + currentScore;
  }
  var currentWordP = currentWordDiv.firstChild;
  currentWordDiv.removeChild(currentWordP);
  enableAllTiles();
  var submitDiv = document.getElementById("submit");
  var a = submitDiv.firstChild;
  while (a.nodeName == "#text") {
    a = a.nextSibling;
  }                                    
  a.onclick = function() {                                  
    alert("Proszę klikać płytki w celu utworzenia słowa.");
  };
}

function enableAllTiles() {
  tiles = document.getElementById("letterbox").getElementsByTagName("a");
  for (i=0; i<tiles.length; i++) {
    var tileClasses = tiles[i].className.split(" ");
    if (tileClasses.length == 4) {
      var newClass = 
        tileClasses[0] + " " + tileClasses[1] + " " + tileClasses[2];
      tiles[i].className = newClass;
      tiles[i].onclick = addLetter;
    }
  }
}
