window.onload = initPage;

function initPage() {
  // wyszukaj miniatury na stronie
  var thumbs = 
    document.getElementById("thumbnailPane").getElementsByTagName("img");

  // prypisz procedurę do każdego obrazka
  for (var i = 0; i < thumbs.length; i++) {
    var image = thumbs[i];
    
    // utwórz funkcję onclick
    image.onclick = function() {
      // find the image name
      var detailURL = 'images/' + this.title + '-detail.jpg';
      document.getElementById("itemDetail").src = detailURL;
      getDetails(this.title);
    }
  }
}

function getDetails(itemName) {
  request = createRequest();
  if (request == null) {
    alert("Nie można utworzyć żąania.");
    return;
  }
  // Wersja dla skryptu serwerowego zwracającego CSV
  var url= "getDetailsXML.php?ImageID=" + escape(itemName);
  request.open("GET", url, true);
  request.onreadystatechange = displayDetails;
  request.send(null);
}

function displayDetails() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      var detailDiv = document.getElementById("description");

      // Usuń dotychczasowe informacje (jeżeli istnieją)
      for (var i=detailDiv.childNodes.length; i>0; i--) {
        detailDiv.removeChild(detailDiv.childNodes[i-1]);
      }

      // Dodaj nowe informacje o przedmiocie.
      var responseDoc = request.responseXML;
      var description = responseDoc.getElementsByTagName("opis")[0];
      var descriptionText = description.firstChild.nodeValue;
      var descriptionP = document.createElement("p");
      descriptionP.appendChild(
        document.createTextNode("Opis: " + descriptionText));
      detailDiv.appendChild(descriptionP);
      var price = responseDoc.getElementsByTagName("cena")[0];
      var priceText = price.firstChild.nodeValue;
      var priceP = document.createElement("p");
      priceP.appendChild(
        document.createTextNode("Cena: " + priceText + " zł"));
      detailDiv.appendChild(priceP);
      var list = document.createElement("ul");
      var urlElements = responseDoc.getElementsByTagName("url");
      for (var i=0; i<urlElements.length; i++) {
        var url = urlElements[i].firstChild.nodeValue;
        var li = document.createElement("li");
        var a = document.createElement("a");
        a.setAttribute("href", url);
        a.appendChild(document.createTextNode(url));
        li.appendChild(a);
        list.appendChild(li);
      }
      detailDiv.appendChild(list);
    }  
  }
}
