# Listing_22-8.py
# Copyright Warren & Csrter Sande, 2013
# Released under MIT license   http://www.opensource.org/licenses/mit-license.php
# Version $version  ----------------------------

# Gra Wysielec, wykorzystujca PyQt

import sys
from PyQt4 import QtCore, QtGui, uic
import random

klasa_formularza = uic.loadUiType("wisielec.ui")[0]

# odszukujemy pooenie(a) liter w sowie
def znajdz_litery(litera, lancuch):
    polozenia = []
    poczatek = 0
    while lancuch.find(litera, poczatek, len(lancuch)) != -1:
        polozenie = lancuch.find(litera, poczatek, len(lancuch))
        polozenia.append(polozenie)
        poczatek = polozenie + 1
    return polozenia

# jeli gracz odgad liter, zastpujemy ni znaki mylinka
def zamien_litery(lancuch, polozenia, litera):
    nowy_lancuch = ''
    for i in range (0, len(lancuch)):
        if i in polozenia:
            nowy_lancuch = nowy_lancuch + litera
        else:
            nowy_lancuch = nowy_lancuch + lancuch[i]
    return nowy_lancuch

# na pocztku programu zamieniamy wszystkie litery w sowie na znaki mylnika
def myslniki(slowo):
    litery = "abcdefghijklmnopqrstuvwxyz"
    nowy_lancuch = ''
    for i in slowo:
        if i in litery:
            nowy_lancuch += "-"
        else:
            nowy_lancuch += i
    return nowy_lancuch

class MojWidzet(QtGui.QMainWindow, klasa_formularza):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.btn_sprawdz.clicked.connect(self.btn_sprawdz_klikniety)        # czymy zdarzenia z procedurami obsugi zdarze
        self.actionZako_cz.triggered.connect(self.menuZakoncz_wybrane)      #
        self.fragmenty_ciala = [self.glowa, self.tulow, self.lewaReka, self.lewaNoga,   # Czci ciaa wisielca
        self.prawaReka, self.prawaNoga]                                                 #        
        self.szubienica = [self.linia1, self.linia2, self.linia3, self.linia4]      # czc i szubienicy
        self.widoczne_fragmenty = 0
        self.biezaceSlowo = ""

        # adujemy list sw
        plik=open("slowa.txt", 'r')
        self.linie = plik.readlines()
        plik.close()
        self.nowa_gra()

    def nowa_gra(self):
        self.odpowiedzi.setText("")
        self.biezaceSlowo = random.choice(self.linie)           # wybieramy losowo jedno sowo z listy
        self.biezaceSlowo = self.biezaceSlowo.strip()
        for i in self.fragmenty_ciala:                          # ukrywamy wisielca
            i.setFrameShadow(QtGui.QFrame.Plain)                #
            i.setHidden(True)                                   #
        for i in self.szubienica:
            i.setFrameShadow(QtGui.QFrame.Plain)
        self.slowo.setText(myslniki(self.biezaceSlowo))         # wywoujemy funkcj ktra zastpuje wszystkie litery znakami mylnika
        self.fragmenty_widoczne = 0

    # gracz wprowadza liter lub sowo
    def btn_sprawdz_klikniety(self):
        odpowiedz = str(self.odpowiedzText.text())
        if str(self.odpowiedzi.text()) != "":
            self.odpowiedzi.setText(str(self.odpowiedzi.text())+", "+odpowiedz)
        else:
            self.odpowiedzi.setText(odpowiedz)
        if len(odpowiedz) == 1:                                             # gracz wprowadzi liter
            if odpowiedz in self.biezaceSlowo:                              #
                polozenia = znajdz_litery(odpowiedz, self.biezaceSlowo)     #
                self.slowo.setText(zamien_litery(str(self.slowo.text()),    #
                                               polozenia,odpowiedz))        #
                if str(self.slowo.text()) == self.biezaceSlowo:             #
                    self.wygrana()                                          #
            else:
                self.zle()
        else:                                                           # gracz wprowadzi sowo
            if odpowiedz == self.biezaceSlowo:                          #
                self.wygrana()                                          #
            else:                                                       #
                self.zle()                                              #
        self.odpowiedzText.setText("")

    def wygrana(self):                                                  # wywietlamy okno dialogowe informujce o wygranej
        QtGui.QMessageBox.information(self,"Wisielec","Wygrae!")      #
        self.nowa_gra()                                                 #

    # obsuga zej odpowiedzi
    def zle(self):
        self.fragmenty_widoczne += 1
        for i in range(self.fragmenty_widoczne):                        # odsaniamy kolejn cz ciaa wisielca
            self.fragmenty_ciala[i].setHidden(False)                    #
        if self.fragmenty_widoczne == len(self.fragmenty_ciala):
            komunikat = "Przegrae. Sowo to: " + self.biezaceSlowo    # gracz przegrywa
            QtGui.QMessageBox.warning(self,"Wisielec", komunikat)       #
            self.nowa_gra()

    def menuZakoncz_wybrane(self):
        self.close()
aplikacja = QtGui.QApplication(sys.argv)
moja_aplikacja = MojWidzet(None)
moja_aplikacja.show()
aplikacja.exec_()

