if 0 {
    #block comment, tcl is weird
echo "--- DUMPING 0 1M"
dump_image dump_samsung_0x00000000_1M 0 0x100000
echo "--- DUMPED 0 1M"

echo "--- DUMPING 0 16M"
dump_image dump_samsung_0x00000000_16M 0 0x1000000
echo "--- DUMPED 0 16M"


echo "--- DUMPING 0x07ff0000 0x10000"
dump_image dump_samsung_0x07ff0000_16M 0x7ff0000 0x10000
echo "--- DUMPED 0x07ff0000 0x10000"


echo "--- DUMPING CONFIG REGS (0x3ff0000 0x10000"
dump_image dump_samsung_0x03ff0000_0x10000 0x7ff0000 0x10000
echo "--- DUMPED 0x07ff0000 0x10000"
}



proc parse_syscfg {val} {
    echo [format " stall enable        %d"        [expr       $val & 1                                   ]]
    echo [format " cache enable        %d"        [expr (     $val & 2                           ) >>  1 ]]
    echo [format " write buffer enable %d"        [expr (     $val & 4                           ) >>  2 ]]
    echo [format " fixed priority      %d"        [expr (     $val & 8                           ) >>  3 ]]    
    echo [format " cache mode          %d"        [expr (     $val &                     0b110000) >>  4 ]]    
    echo [format " internal sram base ptr 0x%08x" [expr (     $val &           0b1111111111000000) << 10 ]]
    echo [format " spe.reg. bank base ptr 0x%08x" [expr       $val & 0b11111111110000000000000000        ]]
    echo [format " sdram mode             0x%x"   [expr       $val & 0x80000000                          ]]
}

proc parse_hextacon {majn minn val} {
    echo [format " extacon %d %d selection setup on nOE : %d cycles" $majn $minn [expr   $val &          0b111]]
    echo [format " extacon %d %d address setup bef. nECS: %d cycles" $majn $minn [expr ( $val &       0b111000)>>3]]
    echo [format " extacon %d %d chip sel hold on   nECS: %d cycles" $majn $minn [expr ( $val &    0b111000000)>>6]]
    echo [format " extacon %d %d                  access: %d cycles" $majn $minn [expr ( $val & 0b111000000000)>>9]]
}

proc parse_extacon {num val} {
    parse_hextacon $num 0 $val
    parse_hextacon $num 1 [expr $val >> 16]
}

proc parse_extdbwth {val} {
    set sz_bw "NA 8 16 32"
    for {set bank 0} {$bank<6} {incr bank} {	
	echo [ format " ROM/SRAM/FLASH bank %d width : %d bits" $bank [lindex $sz_bw [expr $val & 3]]]
	set val [expr $val >> 2 ]
    }
    for {set bank 0} {$bank<4} {incr bank} {	
	echo [ format " DRAM bank %d           width : %d bits" $bank [lindex $sz_bw [expr $val & 3]]]
	set val [expr $val >> 2 ]
    }
    for {set bank 0} {$bank<4} {incr bank} {	
	echo [ format " EXTIO bank %d          width : %d bits" $bank [lindex $sz_bw [expr $val & 3]]]
	set val [expr $val >> 2 ]
    }
}

proc parse_romcon {num val} {
    set pmc_val {"Normal" "4-words page" "8-words page" "16-words page" }
    set tpa_val {5 2 3 4}
    set tacc_val {"Disabled" "2 cycles" "3 cycles" "4 cycles" "5 cycles" "6 cycles" "7 cycles" "reserved"}
    
    echo [format " PMC  %s" [lindex $pmc_val [expr $val & 3]]]
    echo [format " tPA  %d cycles" [lindex $tpa_val [expr ($val >> 2) & 3]]]
#    echo [format " tACC %s" [expr [expr $val >> 4] & 7]]
    echo [format " tACC %s" [ lindex $tacc_val [expr ($val >> 4) & 7]]]

    set baseptr [expr ( ( $val >> 14) & 0x3f)<<20]
    set nextptr [expr ( ( $val >> 24) & 0x3f)<<20]
    set romcon_sz [expr $nextptr - $baseptr]
    
    echo [format " baseptr 0x%08x" $baseptr]
    echo [format " nextptr 0x%08x" $nextptr]
    echo [format " sz      0x%08x" $romcon_sz]
    if {$romcon_sz > 0} {
	echo [format "Dumping romcon%d" $num]
	dump_image [format "out/dump_samsung_romcon%d_0x%08x_0x%x.bin" $num $baseptr $romcon_sz]  $baseptr $romcon_sz
    }

}

proc parse_dramcon {num val} {

    set dram_val {1 2 3 4}
    set can_val {8 9 10 11} 
    if { [expr $val & 1]  } {
	echo "EDO mode"
	echo [format " tCAS  %d cycles" [lindex $dram_val [expr ( $val >> 1 ) & 3]]]
	echo [format " tCP   %d cycles" [lindex $dram_val [expr ( $val >> 3 ) & 1]]]

    } else {
	echo "SDRAM mode"
	echo [format " tCAS  1 cycles" ]
    }
    

    
    echo [format " tRCD  %d cycles" [lindex $dram_val [expr ( $val >> 7 ) & 1]]]
    echo [format " tRP   %d cycles" [lindex $dram_val [expr ( $val >> 8 ) & 3]]]


    set baseptr [expr ( ( $val >> 14 ) & 0x3f ) << 20]
    set nextptr [expr ( ( $val >> 24 ) & 0x3f ) << 20]
    set dramcon_sz [expr $nextptr - $baseptr]
    
    echo [format " baseptr 0x%08x" $baseptr]
    echo [format " nextptr 0x%08x" $nextptr]
    echo [format " sz      0x%08x" $dramcon_sz]

     if {$dramcon_sz > 0} {
	echo [format "Dumping dramcon%d" $num]
	dump_image [format "out/dump_samsung_dramcon%d_0x%08x_0x%x.bin" $num $baseptr $dramcon_sz]  $baseptr $dramcon_sz
    }
    

    echo [format " AddrCol %d bits" [lindex $can_val [expr ($val>>30)&3]]]
}

proc parse_refextcon {val} {
    set baseptr [expr ($val&0x3f0)<<20]
    set endptr  [expr ($baseptr+0x3ffff)]
    set sz 0x3ffff

    echo [format "Dumping extcon" ]
    dump_image [format "out/dump_samsung_extcon_0x%08x_0x%x.bin" $baseptr $sz]  $baseptr $sz

    

    

}

proc samsung_spe_regs {} {
    mem2array syscfg    32 0x3ff0000 1
    mem2array clkcon    32 0x3ff3000 1
    mem2array extacon   32 0x3ff3008 2
    mem2array extdbwth  32 0x3ff3010 1
    mem2array romcon    32 0x3ff3014 6
    mem2array dramcon   32 0x3ff302c 4
    mem2array refextcon 32 0x3ff302c 1
    
    echo [format "\033\[1;31mSYSCFG\033\[0m    0x%08x" $syscfg(0)]
    parse_syscfg  $syscfg(0)
    
    echo [format "\033\[1;31mCLKCON\033\[0m    0x%08x" $clkcon(0)]    
    foreach {n val} [array get extacon] {
	echo [format "EXTACON%d\033\[0m  0x%08x" $n $val]
	parse_extacon $n $val
    }
    echo [format "\033\[1;31mEXTDBWTH\033\[0m  0x%08x" $extdbwth(0)]
    parse_extdbwth $extdbwth(0)
    foreach {n val} [array get romcon] {
	echo [format "\033\[1;31mROMCON%d\033\[0m   0x%08x" $n $val]
	parse_romcon $n $val
    }
    foreach {n val} [array get dramcon] {
	echo [format "\033\[1;31mDRAMCON%d\033\[0m  0x%08x" $n $val]
	parse_dramcon $n $val
    }
    echo [format "\033\[1;31mREFEXTCON\033\[0m 0x%08x" $refextcon(0)]    
     parse_refextcon $refextcon(0)
    
}
echo "--------------------"
set syscfginit 0x4fffff91
echo [format "initial value syscfg 0x%08x" $syscfginit]
parse_syscfg $syscfginit
echo "--------------------"

samsung_spe_regs
echo "-------\033\[1;31mDONE\033\[0m---------"
resume
exit
