#! /usr/bin/python3

#install https://github.com/juhasch/pyBusPirateLite

from pyBusPirateLite.I2C import *

i2c_w_addr = (0x50 << 1)    # where we write -> 0xA0
i2c_r_addr = i2c_w_addr | 1 # where we read  -> 0xA1
curr_addr = 0;
data = bytes()
eeprom_sz = 256 # 256 BYTES
# the device have a 64byte page size
# ! BPv4 change for BPv3
i2c = I2C("/dev/ttyACM0",115200)
i2c.speed='100kHz'
i2c.configure(power=True,pullup=True)
i2c.enter()
f = open('./dump_24lc_BP.data', 'wb')
while( curr_addr < eeprom_sz):
    print("%d %x %x" %( curr_addr, curr_addr & 0xff, (curr_addr & 0xff00)>>8))
    i2c.start()
    r = i2c.transfer( [
        i2c_w_addr,
        curr_addr & 0xff,
    ]
    ) #device w addr
    if(r == False):
        print("device NACKd, bye")
        exit()
    i2c.stop()
    i2c.start()
    data += bytes( i2c.write_then_read(1,64,[i2c_r_addr])) #device r addr
    i2c.stop()
    curr_addr +=64
#print(data)
f.write(data)
f.close()
