#ifndef MX25_H
#define MX25_H
#include <stdint.h>
#include <libopencm3/stm32/f1/nvic.h>
#include <libopencm3/stm32/f1/spi.h>

enum MX25CMD {
        MX25_WREN      = 0x6,
        MX25_WRDI      = 0x4,
        MX25_WRSR      = 0x1,
        MX25_RDID      = 0x9f,
        MX25_RDSR      = 0x5,
        MX25_READ      = 0x3,
        MX25_FAST_READ = 0xb,
        MX25_RDSFDP    = 0x5a,
        MX25_RES       = 0xab,
        MX25_REMS      = 0x90,
        MX25_DREAD     = 0x3b,
        MX25_SE        = 0x20,
        MX25_BE        = 0x52,
        MX25_CE        = 0xC7,
        MX25_PP        = 0x2,
        MX25_RDSCUR    = 0x2b,
        MX25_WRSCUR    = 0x2f,
        MX25_ENSA      = 0xb1,
        MX25_EXSA      = 0xc1,
        MX25_DP        = 0xb9,
        MX25_RDP       = 0xab,
    };

enum MX25CMD_OPSZ {
  MX25_OPTSZ_WREN      = 0x0,
  MX25_OPTSZ_WRDI      = 0x0,
  MX25_OPTSZ_WRSR      = 0x0,
  MX25_OPTSZ_RDID      = 0x0,
  MX25_OPTSZ_RDSR      = 0x0,
  MX25_OPTSZ_READ      = 0x3,
  MX25_OPTSZ_FAST_READ = 0x4,
  MX25_OPTSZ_RDSFDP    = 0x4,
  MX25_OPTSZ_RES       = 0x3,
  MX25_OPTSZ_REMS      = 0x3,
  MX25_OPTSZ_DREAD     = 0x4,
  MX25_OPTSZ_SE        = 0x3,
  MX25_OPTSZ_BE        = 0x3,
  MX25_OPTSZ_CE        = 0x0,
  MX25_OPTSZ_PP        = 0x3,
  MX25_OPTSZ_RDSCUR    = 0x0,
  MX25_OPTSZ_WRSCUR    = 0x0,
  MX25_OPTSZ_ENSA      = 0x0,
  MX25_OPTSZ_EXSA      = 0x0,
  MX25_OPTSZ_DP        = 0x0,
  MX25_OPTSZ_RDP       = 0x0,
  };


void mx25_id(uint32_t spi,uint8_t * buffer);
void mx25_readat(uint32_t spi,uint8_t * buffer,uint32_t addr,uint32_t len);
int  mx25_write_enable(uint32_t spi);
int  mx25_writepage(uint32_t spi,uint8_t * buffer,uint32_t addr,uint32_t len);
int mx25_sectorerase(uint32_t spi,uint32_t addr);
int mx25_getstatus(uint32_t spi);
#endif
