/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.sudoku;

import android.content.Context;
import android.os.Bundle;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;

public class Preferencje extends PreferenceActivity {
    // Nazwy opcji i wartoci domylne
    private static final String OPC_MUZYKA = "muzyka" ;
    private static final boolean OPC_MUZYKA_DOM = true;
    private static final String OPC_PODPOWIEDZI = "podpowiedzi" ;
    private static final boolean OPC_PODPOWIEDZI_DOM = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        addPreferencesFromResource(R.xml.ustawienia);
    }

    /** Pobiera biec warto opcji Muzyka */
    public static boolean wezMuzyka(Context kontekst) {
        return PreferenceManager.getDefaultSharedPreferences(kontekst)
            .getBoolean(OPC_MUZYKA, OPC_MUZYKA_DOM);
    }

    /** Pobiera biec warto opcji Podpowiedzi */
    public static boolean wezPodpowiedzi(Context kontekst) {
        return PreferenceManager.getDefaultSharedPreferences(kontekst)
            .getBoolean(OPC_PODPOWIEDZI, OPC_PODPOWIEDZI_DOM);
    }
}

