/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.przegladarkalokalna;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class PrzegladarkaLokalna extends Activity {
    private static final String ZNACZNIK = "PrzegldarkaLokalna" ;
    private final Handler proceduraobslugi = new Handler();
    private WebView widokWeb;
    private TextView widokTekst;
    private Button przycisk;
               
    /** Obiekt wystawiany dla rodowiska JavaScript */
    private class AndroidPomost {
        public void wywolajAndroida(final String arg) { // zmienna musi by finalna
            proceduraobslugi.post(new Runnable() {
                public void run() {
                    Log.d(ZNACZNIK, "wywolajAndroida(" + arg + ")" );
                    widokTekst.setText(arg);
                }
            });
        }
    }
                              
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        // Wykrywa kontrolki Androida na ekranie
        widokWeb = (WebView) findViewById(R.id.widok_web);
        widokTekst = (TextView) findViewById(R.id.widok_tekstowy);
        przycisk = (Button) findViewById(R.id.przycisk);
        // Tutaj zostaje zdefiniowana reszta metody onCreate...
               
               
        // Uruchamia rodowisko JavaScript wewntrz osadzonej przegldarki
        widokWeb.getSettings().setJavaScriptEnabled(true);

        // Odsania obiekt Java dla kodu JavaScript w przegldarce
        widokWeb.addJavascriptInterface(new AndroidPomost(),
            "android" );

               
        // Konfiguruje funkcj wywoywan w momencie, gdy kod JavaScript
        // prbuje otworzy okno alertu
        widokWeb.setWebChromeClient(new WebChromeClient() {
            @Override
            public boolean onJsAlert(final WebView widok,
                final String url, final String komunikat,
                    JsResult wynik) {
                Log.d(ZNACZNIK, "onJsAlert(" + widok + ", " + url + ", "
                        + komunikat + ", " + wynik + ")" );
                Toast.makeText(PrzegladarkaLokalna.this, komunikat, 3000).show();
                wynik.confirm();
                return true; // zadanie wykonane
            }
        });

        // Wczytuje stron sieci Web z lokalnego katalogu assets
        widokWeb.loadUrl("file:///android_asset/indeks.html" );

                   
                
        // Funkcja ta zostanie wywoana w momencie nacinicia przycisku
        // przez uytkownika, po stronie Androida
        przycisk.setOnClickListener(new OnClickListener() {
            public void onClick(View widok) {
                Log.d(ZNACZNIK, "onClick(" + widok + ")" );
                widokWeb.loadUrl("javascript:wywolajJS('Pozdrowienia z Androida')" );
            }
        });               
    }                                                            
}
