/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.mojamapa;

import android.os.Bundle;

import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;

public class MojaMapa extends MapActivity {
    private MapView mapa;
    private MapController kontroler;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        uruchomWidokMapy();
        uruchomMojaLokalizacje();
    }
    
    /** Znajduje i inicjuje widok mapy */   
    private void uruchomWidokMapy() {
        mapa = (MapView) findViewById(R.id.mapa);
        kontroler = mapa.getController();
        mapa.setSatellite(true);
        mapa.setBuiltInZoomControls(true);
    }

    /** Rozpoczyna ledzenie pozycji na mapie */
    private void uruchomMojaLokalizacje() {
        final MyLocationOverlay powloka = new MyLocationOverlay(this, mapa);
        powloka.enableMyLocation();
        //powloka.enableCompass(); // nie dziaa na emulatorze
        powloka.runOnFirstFix(new Runnable() {
            public void run() {
                // Przyblia map do naszej lokacji
                kontroler.setZoom(8);
                kontroler.animateTo(powloka.getMyLocation());
            }
        });
        mapa.getOverlays().add(powloka);
    }

    @Override
    protected boolean isRouteDisplayed() {
        // Wymagane przez klas MapActivity
        return false;
    }
}
