/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.translator;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

import org.json.JSONException;
import org.json.JSONObject;

import android.util.Log;

public class ZadanieTlum implements Runnable {
    private static final String ZNACZNIK = "ZadanieTumaczenia" ;
    private final Translator translator;
    private final String oryginal, z, na;

    ZadanieTlum(Translator translator, String oryginal, String z,
            String na) {
        this.translator = translator;
        this.oryginal = oryginal;
        this.z = z;
        this.na = na;
    }

    public void run() {
        // Tumaczy oryginalny tekst na jzyk docelowy
        String tlum = robTlumaczenie(oryginal, z, na);
        translator.ustawPrzetlumaczone(tlum);

        // Nastpnie otrzymany wynik zostaje przeoony na jzyk oryginau.
        // W idealnym przypadku powinno si ono pokrywa z pierwotnym zdaniem, ale zazwyczaj tak nie jest.
        String pontlum = robTlumaczenie(tlum, na, z); // zamienione
        translator.ustawPonowniePrzetlum(pontlum);
    }

    /**
    * Wywouje interfejs Tumacz Google, tumaczcy cig znakw
    * z jednego jzyka na inny. Wicej informacji na temat tego interfejsu API:
    * http://code.google.com/apis/ajaxlanguage
    */
    private String robTlumaczenie(String oryginal, String z,
            String na) {
        String wynik = translator.getResources().getString(
                R.string.tlumaczenie_blad);
        HttpURLConnection pol = null;
        Log.d(ZNACZNIK, "robTlumaczenie(" + oryginal + ", " + z + ", "
                + na + ")" );

        try {
            // Sprawdza, czy zadanie zostao przerwane
            if (Thread.interrupted())
                throw new InterruptedException();

            // Tworzy zapytanie typu RESTful dla interfejsu Google API
            String q = URLEncoder.encode(oryginal, "UTF-8" );
            URL url = new URL(
                    "http://ajax.googleapis.com/ajax/services/language/translate"
                        + "?v=1.0" + "&q=" + q + "&langpair=" + z
                        + "%7C" + na);
            pol = (HttpURLConnection) url.openConnection();
            pol.setReadTimeout(10000 /* millisekundy */);
            pol.setConnectTimeout(15000 /* millisekundy */);
            pol.setRequestMethod("GET" );
            pol.addRequestProperty("Referer" ,
                    "http://www.pragprog.com/titles/eband3/hello-android" );
            pol.setDoInput(true);

            // Uruchamia zapytanie
            pol.connect();

            // Sprawdza, czy zadanie zostao przerwane
            if (Thread.interrupted())
                throw new InterruptedException();

            // Odczytuje wyniki zapytania
            InputStreamReader czytnik = new InputStreamReader(
                    pol.getInputStream(), "UTF-8");
            char[] bufor = new char[1024]; // znaki <= bajty
            int dl = -1;
            Writer pisarz = new StringWriter();
            while ((dl = czytnik.read(bufor)) != -1) {
            	pisarz.write(bufor, 0, dl);
            }
            String ladunek = pisarz.toString();
            czytnik.close();


            // Analizuje skadni w celu uzyskania przetumaczonego tekstu
            JSONObject obiektJson = new JSONObject(ladunek);
            wynik = obiektJson.getJSONObject("responseData" )
                    .getString("translatedText" )
                    .replace("&#39;" , "'" )
                    .replace("&amp;" , "&" );

            // Sprawdza, czy zadanie zostao przerwane
            if (Thread.interrupted())
                throw new InterruptedException();

        } catch (IOException e) {
            Log.e(ZNACZNIK, "IOException" , e);
        } catch (JSONException e) {
            Log.e(ZNACZNIK, "JSONException" , e);
        } catch (InterruptedException e) {
            Log.d(ZNACZNIK, "InterruptedException" , e);
            wynik = translator.getResources().getString(
                     R.string.tlumaczenie_przerwane);
        } finally {
            if (pol != null) {
                pol.disconnect();
            }
        }

        // Wszystko zrobione
        Log.d(ZNACZNIK, " -> zwrcono " + wynik);
        return wynik;
    }
}

