import board
import busio
import digitalio
import adafruit_rfm9x

RADIO_FREQ_MHZ = 915.0
CS = digitalio.DigitalInOut(board.RFM9X_CS)
RESET = digitalio.DigitalInOut(board.RFM9X_RST)
spi = busio.SPI(board.SCK, MOSI=board.MOSI, MISO=board.MISO)
rfm9x = adafruit_rfm9x.RFM9x(spi, CS, RESET, RADIO_FREQ_MHZ)
rfm9x.spreading_factor = 7

print('Oczekiwanie na pakiety LoRa...')
i = 0
while True:
   packet = rfm9x.receive(timeout=1.0, keep_listening=True, with_header=True)
   if (i % 2) == 0:
      rfm9x.spreading_factor = 7
   else:
      rfm9x.spreading_factor = 11
   i = i + 1

   if packet is None:
      print('Cisza. Ponowny nasłuch...')
   else:
      print('Odebrane surowe bajty: {0}'.format(packet))
      try:
         packet_text = str(packet, 'ascii')
         print('Odebrane znaki ASCII: {0}'.format(packet_text))
      except UnicodeError:
         print('Pakiet zawiera znaki inne niż ASCII')
      rssi = rfm9x.rssi
      print('Siła sygnału: {0} dB'.format(rssi))