description = [[
Wykrywanie serwerów DICOM (dostawców usługi DICOM) poprzez wysyłanie
częściowego żądania C-ECHO. Żądanie to nosi również popularną nazwę ping DICOM,
ponieważ jest wykorzystywane do testowania połączenia.
Przebieg komunikacji ping DICOM jest następujący:
* Klient -> żądanie A-ASSOCIATE -> Serwer
* Serwer -> odpowiedź A-ASSOCIATE ACCEPT/REJECT -> Klient
* Klient -> żądanie C-ECHO -> Serwer
* Serwer -> odpowiedź C-ECHO -> Klient
* Klient -> żądanie A-RELEASE -> Serwer
* Serwer -> odpowiedź A-RELEASE -> Klient

Ten skrypt wysyła jedynie żądanie A-ASSOCIATE i sprawdza, czy odpowiedź zawiera
kod potwierdzający nawiązanie połączenia. Jest to dość wiarygodny sposób wykrywania 
dostawcy usługi DICOM.
]]

---
-- @usage nmap -p4242 --script dicom-ping <cel>
-- @usage nmap -sV --script dicom-ping <cel>
-- 
-- @output
-- PORT     STATE SERVICE REASON
-- 4242/tcp open  dicom   syn-ack
-- |_dicom-ping: Wykryty dostawca usługi DICOM
--- 
author = "Paulino Calderon <calderon()calderonpale.com>"
license = "Licencja Nmap - patrz http://nmap.org/book/man-legal.html"
categories = {"discovery", "default"}
 
local shortport = require "shortport"
local dicom = require "dicom"
local stdnse = require "stdnse"
local nmap = require "nmap"

portrule = shortport.port_or_service({104, 2761, 2762, 4242, 11112}, 
                                     "dicom", "tcp", "open")
action = function(host, port)
  local dcm_conn_status, err = dicom.associate(host, port)
  if dcm_conn_status == false then
    stdnse.debug1("Błąd połączenia: %s", err)
    if nmap.verbosity() > 1 then
      return string.format("Błąd połączenia: %s", err)
    else
      return nil
    end
  end
  -- Usługa DICOM potwierdzona, aktualizacja nazwy
  port.version.name = "dicom"
  nmap.set_port_version(host, port)
  
  return "Wykryty dostawca usługi DICOM" 
end
