#!/usr/bin/env node

var lora_packet = require('lora-packet');
var AppSKey = new Buffer('ec925802ae430ca77fd3dd73cb2cc588', 'hex');
var packet = lora_packet.fromFields({
   MType: 'Unconfirmed Data Up',
   DevAddr: new Buffer('01020304', 'hex'), // big-endian
   FCtrl: {
      ADR: false,
      ACK: true,
      ADRACKReq: false,
      FPending: false
   },
   payload: 'RH:60',
},
AppSKey,
new Buffer("44024241ed4ce9a68c6a8bc055233fd3", 'hex') // NwkSKey
);

console.log("Oryginalny pakiet: \n" + packet);
var packet_bytes = packet.getPHYPayload().toString('hex');
console.log("hex: " + packet_bytes);
console.log("dane: " + lora_packet.decrypt(packet, AppSKey, null).toString());

var target = packet_bytes;
var index = 24;
target = target.substr(0, index) + '1' + target.substr(index + 1);

console.log("\nHaker zmodyfikował pakiet");
var changed_packet = lora_packet.fromWire(new Buffer(target, 'hex'));
console.log("hex: " + changed_packet.getPHYPayload().toString('hex'));
console.log("dane: " + lora_packet.decrypt(changed_packet, AppSKey, null).toString());