/* Usługa aktualizacji oprogramowania układowego, podatna na ataki - klient
 * ithilgore@sock-raw.org
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <openssl/hmac.h>
#include <syslog.h>

#define PORT 31337
#define FIRMWARE_NAME "./received_firmware.gz"
#define KEY "jUiq1nzpIOaqrWa8R21"

static void fatal(char *fmt, ...)
  __attribute__ ((format (printf, 1, 2)));

static void fatal(char *fmt, ...) {
  va_list ap;
  va_start(ap, fmt);
  fflush(stdout);
  vfprintf(stderr, fmt, ap);
  fprintf(stderr, "\nWyjście!\n");
  va_end(ap);
  exit(1);
}

int main(int argc, char **argv) {
  struct sockaddr_in servaddr;
  int sockfd, filelen, remaining_bytes;
  ssize_t bytes_received;
  size_t offset;
  unsigned char received_hash[16], calculated_hash[16];
  unsigned char *hash_p, *fw_p;
  unsigned int hash_len;
  uint32_t hdr_fwlen;
  char server_ip[16] = "127.0.0.1";
  FILE *file;

  if (argc > 1)
    strncpy((char *)server_ip, argv[1], sizeof(server_ip) - 1);

  openlog("firmware_update", LOG_CONS | LOG_PID | LOG_NDELAY, LOG_LOCAL1);
  syslog(LOG_NOTICE, "PID procesu aktualizacji oprogramowania: %d", getpid());

  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  inet_pton(AF_INET, server_ip, &(servaddr.sin_addr));
  servaddr.sin_port = htons(PORT);

  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    fatal("Błąd otwarcia gniazda: %s\n", strerror(errno));

  if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(struct sockaddr)) == -1)
    fatal("Błąd połączenia z serwerem %s: %s\n", server_ip, strerror(errno));

  /* Wysłanie klucza uwierzytelniającego  */
  write(sockfd, &KEY, sizeof(KEY));
  syslog(LOG_NOTICE, "Uwierzytelnienie w %s za pomocą klucza %s", server_ip, KEY);

  /* Odebranie wielkości oprogramowania układowego */
  recv(sockfd, &hdr_fwlen, sizeof(hdr_fwlen), 0);
  filelen = ntohl(hdr_fwlen);
  printf("Wielkość pliku: %d\n", filelen);

  /* Odebranie sumy kontrolnej */
  recv(sockfd, received_hash, sizeof(received_hash), 0);
  
  /* Odebranie pliku */
  if (!(fw_p = malloc(filelen)))
    fatal("Brak pamięci dla aktualizacji oprogramowania\n");

  remaining_bytes = filelen;
  offset = 0;
  while (remaining_bytes > 0) {
    bytes_received = recv(sockfd, fw_p + offset, remaining_bytes, 0);
    offset += bytes_received; 
    remaining_bytes -= bytes_received;
#ifdef DEBUG
    printf("Liczba odebranych bajtów: %ld\n", bytes_received);
#endif
  }

  /* Weryfikacja oprogramowania poprzez porównanie odebranej sumy kontrolnej z wyliczoną */
  hash_p = calculated_hash;
  hash_p = HMAC(EVP_md5(), &KEY, sizeof(KEY) - 1, fw_p, filelen, hash_p, &hash_len);

  printf("Wyliczona suma kontrolna: ");
  for (int i = 0; i < hash_len; i++)
    printf("%x", hash_p[i]);
  printf("\nOdebrana suma kontrolna: ");
  for (int i = 0; i < sizeof(received_hash); i++)
    printf("%x", received_hash[i]);
  printf("\n");

  if (!memcmp(calculated_hash, received_hash, sizeof(calculated_hash)))
    printf("Sumy zgodne\n");
  else {
    fatal("Sumy niezgodne\n");
  }

  /* Zapisanie oprogramowania na dysku */
  if (!(file = fopen(FIRMWARE_NAME, "w")))
    fatal("Błąd otwarcia pliku do zapisu: %s\n", strerror(errno));
  fwrite(fw_p, filelen, 1, file);

  syslog(LOG_NOTICE, "Oprogramowanie pobrane pomyślnie");
  
  /* Operacje porządkowe */
  free(fw_p);
  fclose(file);
  close(sockfd);
  closelog();
  return 0;
}