# Przykładowy kod do książki Hadoop. Kompletny przewodnik

To repozytorium zawiera przykładowy kod do czwartego wydania książki Hadoop. Kompletny przewodnik (Hadoop: The Definitive Guide, Fourth Edition; http://shop.oreilly.com/product/0636920033448.do)
autorstwa Toma White'a (O'Reilly, 2014).

Dostępny jest też kod do wydań pierwszego, drugiego i trzeciego.

Zauważ, że nazwy i numery rozdziałów zmieniają się między wydaniami (zobacz
https://github.com/tomwhite/hadoop-book/wiki/Chapter-Numbers-By-Edition).

Kod do pierwszego wydania: http://github.com/tomwhite/hadoop-book/tree/1e
Kod do drugiego wydania: http://github.com/tomwhite/hadoop-book/tree/2e
Kod do trzeciego wydania: http://github.com/tomwhite/hadoop-book/tree/3e

## Budowanie i uruchamianie kodu

Aby zbudować kod, najpierw musisz zainstalować Mavena i Javę. Następnie wpisz:

```bash
% mvn package -DskipTests
```

To uruchomi pełny proces budowania kodu i utworzy przykładowe pliki JAR w katalogu najwyższego poziomu (
`hadoop-examples.jar`).

Aby uruchomić przykłady z konkretnego rozdziału, najpierw zainstaluj potrzebny w danym rozdziale komponent (
Hadoop, Pig, Hive itd.), a następnie wywołaj polecenia opisane w rozdziale.

Przykładowe zbiory danych są dostępne w katalogu input. Kompletny zbiór danych meteorologicznych
nie został dołączony z powodu jego wielkości. Z poświęconej książce witryny (http://www.hadoopbook.com/) 
dowiesz się, jak pobrać kompletny zbiór danych.

## Wersje komponentów Hadoopa

To wydanie książki jest napisane z myślą o wersji Hadoop 2. Kod nie został dokładnie przetestowany
w wersji Hadoop 1, choć większość przykładów powinna w niej działać.

Dokładną listę wersji komponentów, dla których przetestowano kod, znajdziesz w 
w pliku book/pom.xml.

## Copyright

Copyright (C) 2014 Tom White