import turtle


# importujemy moduł turtle


def trojkat_rownoboczny(x, y, bok, kolor):
    # tworzymy funkcję o nazwie trojkat_rownoboczny
    # funkcja ta przyjmuje cztery argumenty
    # pierwsze dwa określają pozycję trójkąta
    # argument o nazwie bok przechowuje długość
    # boku trójkąta
    # ostatni argument określa kolor linii i wypełnienia
    turtle.setheading(0)
    # ustawiamy kierunek żółwia na wartość zero
    # ustawienie to powoduje, że żółw będzie skierowany w prawo
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x, y)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii
    turtle.color(kolor, kolor)
    # ustawiamy kolor linii oraz wypełnienia
    # na wartość, jaka jest przechowywana w zmiennej kolor
    turtle.backward(bok / 2)
    # przesuwamy do tyłu żółwia o połowę wartości zmiennej bok
    turtle.begin_fill()
    # rozpoczynamy wypełnianie
    for _ in range(3):
        # pętla wykona się trzy razy
        turtle.forward(bok)
        # przesuwamy żółwia o wartość zmiennej bok do przodu
        turtle.left(120)
        # obracamy żółwia o 120 stopni w lewo
    turtle.end_fill()
    # kończymy wypełnianie figury


def kwadrat(x, y, bok, kolor):
    # tworzymy funkcję o nazwie kwadrat
    # funkcja ta przyjmuje cztery argumenty
    # pierwsze dwa określają pozycję kwadratu
    # argument o nazwie bok przechowuje długość
    # boku kwadratu
    # ostatni argument określa kolor linii i wypełnienia
    turtle.setheading(0)
    # ustawiamy kierunek żółwia na wartość zero
    # ustawienie to powoduje, że żółw będzie skierowany w prawo
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x - bok / 2, y - bok / 2)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    # od wartości x oraz y odejmowana jest
    # wartość połowy zmiennej bok
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii
    turtle.color(kolor, kolor)
    # ustawiamy kolor linii i wypełnienia
    # na wartość, jaka jest przechowywana w zmiennej kolor
    turtle.begin_fill()
    # rozpoczynamy wypełnianie
    for _ in range(4):
        # pętla wykona się czterokrotnie
        turtle.forward(bok)
        # przesuwamy żółwia o wartość zmiennej bok do przodu
        turtle.left(90)
        # obracamy żółwia o 90 stopni w lewo
    turtle.end_fill()
    # kończymy wypełnianie figury


def choinka(x, y, skala=1):
    # tworzymy funkcję o nazwie choinka
    # funkcja ta przyjmuje trzy argumenty
    # pierwsze dwa określają pozycję choinki
    # ostatni z nich pozwala na określenie skali
    # domyślnie ustawiony jest na 1
    trojkat_rownoboczny(x, y + 200 * skala, 200 * skala, "green")
    trojkat_rownoboczny(x, y + 100 * skala, 240 * skala, "green")
    trojkat_rownoboczny(x, y, 260 * skala, "green")
    # trzykrotnie wywołujemy funkcję trojkat_rownoboczny
    # każde z trzech wywołań różni się wartością współrzędnej y
    # wywołanie to ma na celu narysowanie głównej
    # części choinki złożonej z trzech trójkątów równobocznych
    kwadrat(x, y - 25 * skala, 50 * skala, "brown")
    # wywołujemy funkcję kwadrat, funkcja ta odpowiedzialna jest
    # za narysowanie pnia choinki


choinka(0, 0)
# wywołujemy funkcję o nazwie choinka
# funkcja ta może przyjmować dwa lub trzy argumenty
# funkcja ta odpowiada za rysowanie choinki w punkcie 0, 0


turtle.mainloop()
# zapobiegamy zamknięciu się okna
# po zakończeniu rysowania
