import turtle


# importujemy moduł turtle


def rysuj_tecze(x, y, promien):
    # tworzymy funkcję o nazwie rysuj_tecze
    # funkcja ta przyjmuje trzy argumenty
    # pierwsze dwa określają pozycję, gdzie ma zostać
    # narysowana tęcza, zaś ostatni z nich
    # określa promień tęczy, która jest rysowana jako
    # kolorowe półokręgi.
    turtle.setheading(90)
    # ustawiamy kierunek żółwia na wartość 90
    # ustawienie to powoduje, że żółw zwrócony jest w górę 
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x + promien, y)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    # do wartości zmiennej x dodawana jest wartość
    # zmiennej promień, zabieg ten ma sprawić,
    # by środek rysowanego półokręgu znajdował
    # się w punkcie określonym przez wartość x i y
    turtle.pendown()
    # opuszczamy żółwia, od tej pory 
    # poruszając się, pozostawia za 
    # sobą ślad w postaci linii 
    kolory = ["red", "orange",
              "yellow", "green",
              "blue", "indigo",
              "purple", "white"]
    # tworzymy listę o nazwie kolory
    # lista ta posiada osiem elementów 
    for kolor in kolory:
        # pętla przechodzi po liście kolory
        # wykona się osiem razy 
        turtle.fillcolor(kolor)
        # ustawiamy kolor wypełnienia na wartość, 
        # jaką przyjmuje aktualnie zmienna kolor
        # zmienna ta będzie przyjmować wartość red
        # w pierwszym obrocie pętli, w kolejnym — orange
        # w kolejnym yellow i tak dalej aż do końca listy kolory 
        turtle.begin_fill()
        # rozpoczynamy wypełnianie 
        turtle.circle(promien, 180)
        # rysujemy połowę okręgu o promieniu określonym
        # przez wartość zmiennej promień
        turtle.end_fill()
        # kończymy wypełnianie figury
        promien -= 20
        # zmniejszamy wartość zmiennej promień o 20 
        turtle.right(90)
        # obracamy żółwia o 90 stopni w prawo 
        turtle.penup()
        # podnosimy żółwia, od tej pory
        # poruszając się, nie pozostawia za
        # sobą śladu w postaci linii
        turtle.backward(2 * promien + 20)
        # przesuwamy żółwia do tyłu
        # o wartość wyrażenia 2 * promien + 20 
        turtle.pendown()
        # opuszczamy żółwia, od tej pory
        # poruszając się, pozostawia za
        # sobą ślad w postaci linii
        turtle.right(90)
        # obracamy żółwia o 90 stopni w prawo


rysuj_tecze(0, 0, 400)
# wywołujemy funkcję rysującą tęczę
# środek tęczy znajdzie się w punkcie 0, 0 
# zaś rozmiar promienia tej tęczy będzie 
# równy 400 pikseli


turtle.mainloop()
# zapobiegamy zamknięciu się okna 
# po zakończeniu rysowania
