import turtle

# importujemy moduł turtle
turtle.pensize(80)
# ustawiamy rozmiar linii, którą rysuje żółw,
# na wartość równą 80 pikseli
turtle.colormode(255)
# funkcja colormode pozwala na zmianę sposobu
# podawania kolorów, wywołanie jej z parametrem 255
# od tej pory każdy z kolorów może być definiowany
# jako trzyelementowa krotka zawierająca wartości
# z przedziału od 0 do 255
# (red, green, blue)


kolory = []
# tworzymy pustą listę o nazwie kolory
# będziemy w niej zapisywać kolory w postaci krotek
for i in range(256):
    kolory.append((i, 0, 0))
# do listy kolory dodajemy krotki zaczynające się od
# (0,0,0), a kończymy na kolorze (255,0,0)

for i in range(255, -1, -1):
    kolory.append((i, 255 - i, 0))
# do listy kolory dodajemy krotki zaczynające się od
# (255,0,0), a kończymy na kolorze (0,255,0)

for i in range(255, -1, -1):
    kolory.append((0, i, 255 - i))
# do listy kolory dodajemy krotki zaczynające się od
# (0,255,0), a kończymy na kolorze (0,0,255)


turtle.penup()
# podnosimy żółwia, od tej pory
# poruszając się, nie pozostawia za
# sobą śladu w postaci linii
turtle.backward(384)
# przesuwamy żółwia o 384 piksele do tyłu
turtle.pendown()
# opuszczamy żółwia, od tej pory
# poruszając się, pozostawia za
# sobą ślad w postaci linii


for kolor in kolory:
    # pętla wykona się 768 razy
    # dokładnie tyle elementów ma lista kolory
    turtle.forward(1)
    # przesuwamy żółwia o 1 piksel do przodu
    turtle.pencolor(kolor)
    # ustawiamy kolor linii na wartość zmiennej kolor
    # zmienna kolor za każdym obrotem pętli będzie
    # przyjmowała kolejny, inny kolor z listy kolory

turtle.mainloop()
# zapobiegamy zamknięciu się okna
# po zakończeniu rysowania
