import turtle
# importujemy moduł turtle

import math


# importujemy moduł math
# moduł ten dostarcza funkcji matematycznych 
# takich jak pierwiastkowanie czy potęgowanie


def trojkat_wpisany_w_okrag(x, y, kat, bok):
    # tworzymy funkcję o nazwie trojkat_wpisany_w_okrag
    # funkcja ta przyjmuje cztery argumenty
    # pierwsze dwa określają pozycję środka okręgu
    # kolejny określa kąt, pozwala na obracanie trójkąta
    # ostatni argument określa długość boku narysowanego trójkąta 
    turtle.pensize(2)
    # ustawiamy rozmiar linii, którą rysuje żółw,
    # na wartość równą 2 piksele
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.setheading(kat)
    # ustawiamy, w którą stronę
    # ma być zwrócony żółw, gdzie wartość 0
    # oznacza w prawo, 90 to pionowo w górę,
    # 180 w lewo, a 270 w dół
    turtle.goto(x, y)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y 
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii
    punkty = []
    # tworzymy pustą listę o nazwie punkty,
    # w której będą zapisywane współrzędne wierzchołków 
    # trójkąta równobocznego
    r = bok * math.sqrt(3) / 3
    # tworzymy zmienną r
    # zmienna ta będzie przechowywać obliczoną
    # wartość promienia okręgu
    for _ in range(3):
        # pętla wykona się trzy razy
        turtle.forward(r)
        # przesuwamy żółwia o wartość zmiennej r do przodu 
        punkty.append(turtle.pos())
        # dodajemy do listy punkty aktualną pozycję żółwia 
        turtle.backward(r)
        # przesuwamy żółwia o wartość zmiennej r do tyłu 
        turtle.left(120)
        # obracamy żółwia o 120 stopni w lewo
    punkty.append(punkty[0])
    # dodajemy do listy punkty ponownie wartość elementu o indeksie 0 
    for punkt in punkty:
        # pętla wykona się tyle razy, ile elementów ma lista punkty, 
        # czyli czterokrotnie
        # każdy kolejny obrót pętli powoduje, że zmienna punkt
        # będzie miała kolejną wartość z listy punkty 
        turtle.goto(punkt)
        # przemieszcza żółwia do pozycji określonej przez wartość
        # zmiennej punkt, działanie to spowoduje narysowanie trójkąta
    turtle.left(90)
    # obracamy żółwia o 90 stopni w lewo
    turtle.circle(r)
    # rysujemy okrąg o promieniu równym wartości zmiennej r


trojkat_wpisany_w_okrag(0, 0, 90, 200)
# wywołujemy funkcję o nazwie trojkat_wpisany_w_okrag 
# funkcja ta narysuje trójkąt równoboczny wpisany w okrąg 
# środek okręgu będzie w punkcie o współrzędnych 0, 0
# zaś bok tego trójkąta będzie miał długość 200 pikseli


turtle.mainloop()
# zapobiegamy zamknięciu się okna 
# po zakończeniu rysowania
