import turtle

# importujemy moduł turtle
turtle.pensize(4)


# ustawiamy rozmiar linii, którą rysuje żółw, 
# na wartość równą 4 piksele


def kwadrat_pusty(x, y, a):
    # tworzymy funkcję o nazwie kwadrat_pusty
    # funkcja ta przyjmuje trzy argumenty
    # pierwsze dwa to pozycja x, y środka kwadratu
    # zaś ostatni argument określa wielkość boku figury
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x - (a / 2), y - (a / 2))
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    # od wartości x oraz y odejmowana jest
    # wartość połowy zmiennej a
    turtle.pendown()
    # opuszczamy żółwia, od tej pory 
    # poruszając się, pozostawiamy za 
    # sobą ślad w postaci linii
    for _ in range(4):
        # pętla wykona się cztery razy
        turtle.forward(a)
        # przesuwamy żółwia o wartość zmiennej a do przodu 
        turtle.left(90)
        # obracamy żółwia o 90 stopni w lewo


def kwadrat_z_kropka(x, y, a):
    # tworzymy funkcję o nazwie kwadrat_z_kropka
    # funkcja ta wykorzystuje wcześniej utworzoną
    # funkcję o nazwie kwadrat_pusty
    # najpierw wywoływana jest funkcja rysująca kwadrat 
    # zaś później następuje narysowanie czarnej kropki
    # wewnątrz kwadratu
    kwadrat_pusty(x, y, a)
    # wywołujemy funkcję kwadrat_pusty
    # argumenty tej funkcji są takie same
    # jak funkcji kwadrat_z_kropka
    # działanie to ma na celu uniknięcie
    # powtarzania się kodu
    r = (a / 2) * 0.8
    # obliczamy promień okręgów
    # wartość zmiennej r będzie równa 80 procent
    # z połowy wartości zmiennej a
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x, y - r)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    # od wartości y odejmowana jest
    # wartość zmiennej r
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii
    turtle.begin_fill()
    # rozpoczynamy wypełnianie
    turtle.circle(r)
    # rysujemy okrąg o promieniu równym zmiennej r 
    turtle.end_fill()
    # kończymy wypełnianie figury


def emblemat_hakerow(x, y, a):
    # tworzymy funkcję o nazwie emblemat_hakerow 
    # funkcja ta przyjmuje trzy argumenty
    # pierwsze dwa określają pozycję lewego dolnego 
    # kwadracika emblematu
    # zaś ostatni argument określa wielkość
    # pojedynczego kwadracika
    licznik = 0
    # tworzymy zmienną o nazwie licznik oraz
    # przypisujemy jej wartość 0
    for _ in range(3):
        # pętla wykona się trzykrotnie
        kopia_x = x
        # tworzymy zmienną o nazwie kopia_x
        # zmienna ta będzie przechowywać kopię 
        # zmiennej x
        for _ in range(3):
            # pętla wykona się trzykrotnie
            if licznik == 0 or \
                    licznik == 1 or \
                    licznik == 2 or \
                    licznik == 5 or \
                    licznik == 7:
                # jeśli wartość zmiennej licznik
                # będzie wynosić 0, 1, 2, 5, 7, to
                # zostanie narysowany kwadrat z kropką 
                kwadrat_z_kropka(kopia_x, y, a)
            else:
                # w przeciwnym razie zostanie narysowany 
                # pusty w środku kwadrat 
                kwadrat_pusty(kopia_x, y, a)
            kopia_x += a
            # zwiększamy wartość zmiennej kopia_x
            # o wartość zmiennej a, czyli długość boku
            # pojedynczego kwadratu tworzącego emblemat 
            licznik += 1
            # zwiększamy wartość zmiennej licznik o 1
        y += a
        # zwiększamy wartość zmiennej y
        # o wartość zmiennej a, czyli długości boku
        # pojedynczego kwadratu tworzącego emblemat


emblemat_hakerow(0, 0, 80)
# wywołujemy funkcję emblemat_hakerow
# środek lewego dolnego kwadratu zostanie narysowany
# w punkcie 0, 0, zaś każdy z kwadracików tworzących
# emblemat hakerów będzie miał bok o długości 80 pikseli


turtle.mainloop()
# zapobiegamy zamknięciu się okna
# po zakończeniu rysowania
