// Program guess wymaga od gracza zgadywania losowych liczb.
package main

import (
	"bufio"
	"fmt"
	"log"
	"math/rand"
	"os"
	"strconv"
	"strings"
	"time"
)

func main() {
	seconds := time.Now().Unix()
	rand.Seed(seconds)
	target := rand.Intn(100) + 1
	fmt.Println("Wybrałem liczbę losową z przedziału od 1 do 100.")
	fmt.Println("Potrafisz ją zgadnąć?")

	reader := bufio.NewReader(os.Stdin)
	success := false
	for guesses := 0; guesses < 10; guesses++ {
		fmt.Println("Liczba pozostałych prób:", 10-guesses, ".")
		fmt.Print("Zgadnij liczbę: ")
		input, err := reader.ReadString('\n')
		if err != nil {
			log.Fatal(err)
		}
		input = strings.TrimSpace(input)
		guess, err := strconv.Atoi(input)
		if err != nil {
			log.Fatal(err)
		}

		if guess < target {
			fmt.Println("Ups, podana wartość jest za MAŁA.")
		} else if guess > target {
			fmt.Println("Ups, podana wartość jest za DUŻA.")
		} else {
			success = true
			fmt.Println("Świetnie! Zgadłeś!")
			break
		}
	}

	if !success {
		fmt.Println("Niestety, nie zgadłeś. Szukana liczba to:", target, ".")
	}
}
