﻿# -*- coding: utf-8 -*-

from google.appengine.ext import db
from google.appengine.api import users
from google.appengine.ext import webapp
from google.appengine.ext.webapp import template
from google.appengine.ext.webapp.util import run_wsgi_app
import datetime
import os


#START: ChatMessage
class ChatMessage(db.Model):
    user = db.StringProperty(required=True)
    timestamp = db.DateTimeProperty(auto_now_add=True)
    message = db.TextProperty(required=True)
    chat = db.StringProperty(required=True)

CHATS = [u'glowny', u'ksiazka', u'plomien' ]
#KONIEC: ChatMessage

#START: Ogólny Chat
class GenericChatPage(webapp.RequestHandler):
  def get(self):
    user = users.get_current_user()
    requested_chat = self.request.get("chat", default_value=None)
    if requested_chat == None or requested_chat not in CHATS:
      template_params = {
          'title': u"Błąd! Nie znaleziono żądanego pokoju czatu!",
          'chatname': requested_chat,
          'chats': CHATS
          }
      error_template = os.path.join(os.path.dirname(__file__), 'error.html')
      page = template.render(error_template, template_params)
      self.response.out.write(page)
    else:
      messages = db.GqlQuery("SELECT * from ChatMessage WHERE chat = :1 "
                             "ORDER BY timestamp", requested_chat)
      template_params = {
          'title': u"Witamy w pokoju czatu MarkCC w App Engine",
          'msg_list': messages,
          'chat': requested_chat,
          'chats': CHATS
          }
      path = os.path.join(os.path.dirname(__file__), 'multichat.html')
      page = template.render(path, template_params)
      self.response.out.write(page)
#KONIEC: Ogólny czat    

#START: Widok na 20 ostatnich wiadomości
class ChatRoomCountedHandler(webapp.RequestHandler):
  def get(self):
    user = users.get_current_user()
    if user is None: 
      self.redirect(users.create_login_url(self.request.uri))
    else:
      self.response.headers['Content-Type'] = 'text/html; charset=UTF-8'
      messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY timestamp "
                             "DESC LIMIT 20")
      for msg in messages:
        msg.deltatime = datetime.datetime.now() - msg.timestamp
      template_values = {
        'title': u"Witamy w pokoju czatu MarkCC w App Engine",
        'msg_list': messages
        }
      path = os.path.join(os.path.dirname(__file__), 'count.html')
      page = template.render(path, template_values)
      self.response.out.write(page)
#KONIEC: Widok na 20 ostatnich wiadomości


#START: Strona powitalna
class ChatRoomLandingPage(webapp.RequestHandler):
  def get(self):
    user = users.get_current_user()
    if user is None: 
      self.redirect(users.create_login_url(self.request.uri))
    else:
      self.response.headers['Content-Type'] = 'text/html; charset=UTF-8'
      messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY timestamp "
                             "DESC LIMIT 20")
      template_values = {
        'title': u"Witamy w pokoju czatu MarkCC w App Engine",
        'msg_list': messages,
        'chats': CHATS
        }
      path = os.path.join(os.path.dirname(__file__), 'landing.html')
      page = template.render(path, template_values)
      self.response.out.write(page)
#KONIEC: Stron powitalna

#START: Handler obsługujący żądania POST
class ChatRoomPoster(webapp.RequestHandler):
  def post(self):
    user = users.get_current_user()
    msgtext = self.request.get("message")
    chat = self.request.get("chat")
    msg = ChatMessage(user=user.nickname(), message=msgtext, chat=chat)
    msg.put()
    # Po dodaniu nowej wiadomości przekierowujemy użytkownika na stronę czatu,
    # z którego wtsłano wiadomość,
    self.redirect('/enterchat?chat=%s' % chat)
#KONIEC: Handler obsługujący żądania POST

# START: Frame
chatapp = webapp.WSGIApplication([('/', ChatRoomLandingPage),
                                  ('/talk', ChatRoomPoster),
                                  ('/enterchat', GenericChatPage),
                                  ('/counted', ChatRoomCountedHandler)])

# KONIEC: Frame
def main():
    run_wsgi_app(chatapp)

if __name__ == "__main__":
    main()
