﻿# -*- coding: utf-8 -*-

from datetime import datetime
import string

class Resource(object):
    @staticmethod
    def MakeResource():
        return Resource(content=None, attributes={})

    def fs_put(self, content):
        self.content = content

    def fs_get(self):
        return self.content

    def fs_setAttribute(self, name, value):
        self.attributes[name] = value

    def fs_getAttribute(self, name):
        return self.attributes[name]

    def isDir(self):
        return self.getAttribute("children") is not None

    def addChild(self, name, resource):
        if self.getAttribute("children") is None:
            self.setAttribute("children", {})
        self.getAttribute("children")[name] = resource

class FileSystem(object):
    @staticmethod
    def MakeFilesystem():
        fs = FileSystem()
        fs.root = FileSystem.MakeFile("/", "root", "")
        return self
    
    @staticmethod
    def MakeFile(name, owner, content):
        file = Resource()
        file.put(content)
        file.setAttribute("owner", owner)
        file.setAttribute("time", datetime.now())
        return file
    
    def getRoot(self):
        return self.root

    def getResourceFromChild(self, child, nameElements):
        """Metoda pobierająca rekurencyjnie ścieżkę do pliku. Parametr child 
        jest nazwą katalogu przechodnio zawartego w zasobie, będącym celem wywołania.
        Parametr nameElements jest listą komponentów ścieżki występujących po nazwie 
        zawartości parametru child. Każde rekurencyjne wywołanie ustala kolejny element tej ścieżki,
        po czym wywołuje tę metodę raz jeszcze. Jeśli parametr nameElements będzie pustry dojdzie
        do zakonczenia operacji."""
        if nameElements is []:
            return child
        childsChildren = child.getAttribute("children")
        if childsChildren is None:
            return None
        else:
            nextChild = childsChildren[nameElements[0]]
            if nextChild is None:
                return None
            else:
                return self.getResourceFromChild(nextChild, nameElements[1:])
                    
    def getResourceAtPath(self, path):`
        pathElements = string.split(path, "/")
        self.getResourceFromChild(self.getRoot(), pathElements)
