﻿import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import datetime


class ChatError(Exception):
    """ Wyjątki obsługujące wszelkiego rodzaju błędy w czacie."""
    def __init__(self, msg):
        self.message = msg


# START: ChatMessage
class ChatMessage(object):
    """Pojedyncza wiadomość wysłana przez użytkownika czatu"""
    def __init__(self, user, text):
        self.sender = user
        self.msg = text
        self.time = datetime.datetime.now()
    def __str__(self):
        return "Od: %s o godzinie %s: %s" % (self.sender.username,
                                       self.time,
                                       self.msg)
	def __unicode__(self):
		return "Od: %s o godzinie %s: %s" % (self.sender.username,
                                       self.time,
                                       self.msg)

# KONIEC: ChatMessage

# START: ChatUser
class ChatUser(object):
    """Użytkownik biorący udział w czacie"""
    def __init__(self, username):
        self.username = username
        self.rooms = {}

    def subscribe(self, roomname):
        if roomname in ChatRoom.rooms:
            room = ChatRoom.rooms[roomname]
            self.rooms[roomname] = room
            room.addSubscriber(self)
        else:
            raise ChatError("Nie znaleziono pokoju %s" % roomname)

    def sendMessage(self, roomname, text):
        if roomname in self.rooms:
            room = self.rooms[roomname]
            cm = ChatMessage(self, text)
            room.addMessage(cm)
        else:
            raise ChatError("Użytkownik %s nie jest zarejestrowany w pokoju %s" % 
                            (self.username, roomname))

    def displayChat(self, roomname, out):
        if roomname in self.rooms:
            room = self.rooms[roomname]
            room.printMessages(out)
        else:
            raise ChatError("Użytkownik %s nie jest zarejestrowany w pokoju %s" % 
                            (self.username, roomname))
# KONIEC: ChatUser
        
# START: ChatRoom
class ChatRoom(object):
    """Pokój"""

    rooms = {}
    
    def __init__(self, name):
        self.name = name
        self.users = []
        self.messages = []
        ChatRoom.rooms[name] = self

    def addSubscriber(self, subscriber):
        self.users.append(subscriber)
        subscriber.sendMessage(self.name, 'Użytkownik %s dołączył do dyskusji.' %
                               subscriber.username)

    def removeSubscriber(self, subscriber):
        if subscriber in self.users:
            subscriber.sendMessage(self.name, 
                                   "Użytkownik %s opóścił pokój." % 
                                   subscriber.username)
            self.users.remove(subscriber)

    def addMessage(self, msg):
        self.messages.append(msg)

    def printMessages(self, out):
        print >>out, "Lista wiadomości: %s" % self.name
        for i in self.messages:
            print >>out, i
			


# KONIEC: ChatRoom

# START: ChatMain
def main():
    room = ChatRoom("Main") 
    markcc = ChatUser("MarkCC")
    markcc.subscribe("Main")
    prag = ChatUser("Prag")
    prag.subscribe("Main")

    markcc.sendMessage("Main", "Hej! Jest tu kto?")
    prag.sendMessage("Main", "Tak, ja tu jestem.")
    markcc.displayChat("Main", sys.stdout)


if __name__ == "__main__":
    main()
# KONIEC: ChatMain


