package com.pragprog.aebook.chat.server;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//START: reporter
@SuppressWarnings("serial")
public class Reporter extends HttpServlet {
	
	Logger logger = Logger.getLogger(Reporter.class.getName());

	@Override
	@SuppressWarnings("unchecked")
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		String toAddress = req.getParameter("to");
		PersistenceManager persister = Persister.getPersistenceManager();
		Query query = persister.newQuery(PChatMessage.class);
		query.setFilter("date >= yesterday");
		query.declareParameters("long yesterday");
		query.setOrdering("date");
		long yesterday = System.currentTimeMillis() - (24 * 60 * 60 * 1000);
		List<PChatMessage> messages =
		    (List<PChatMessage>)query.execute(yesterday);
		resp.setContentType("text/html");
		
		PrintWriter out = new PrintWriter(new CharArrayWriter());
		out.println("<html>");
		out.println("  <head>");
		out.println("    <title>Raport z wykorzystania aplikacji czatu</title>");
		out.println("  </head>");
		out.println("  <body>");
		out.println("  <h1>Raport z wykorzystania aplikacji czatu</h1>");
		out.println("  <p> Suma rozmiarów wiadomości z ostatnich 24 godzin: " +
	        messages.size());
		out.println("</body></html>");
		out.close();
		String report = out.toString();

		Session mailSession =
		    Session.getDefaultInstance(new Properties(), null);
	    try {
	      Message msg = new MimeMessage(mailSession);
	      msg.setFrom(new InternetAddress(toAddress));
	      msg.addRecipient(Message.RecipientType.TO,
	          new InternetAddress(req.getParameter("to")));
	      msg.setSubject("Raport z wykorzystania aplikacji czatu");
	      msg.setText(report);
	      Transport.send(msg);
	   } catch (AddressException e) {
		   // Nasz adres email jest stary, więc nie powinno dojść
		   // do wygenerowania tego wyjątku.
	   } catch (MessagingException e) {
		   logger.log(Level.INFO, "Błąd w trakcie wysyłania danych: " + e);
	   }		
	}
}
//KONIEC: reporter