﻿# -*- coding: utf-8 -*-

from google.appengine.ext import webapp
from google.appengine.ext.webapp.util import run_wsgi_app
import datetime

from google.appengine.ext import db

#START: ChatMessage
class ChatMessage(db.Model):
    user = db.StringProperty(required=True)
    timestamp = db.DateTimeProperty(auto_now_add=True)
    message = db.TextProperty(required=True)
    chat = db.StringProperty(required=True)

CHATS = ['main', 'book', 'flame' ]
#END: ChatMessage

#START: UserRoles
class UserRole(db.Model):
    name = db.StringProperty(required=True)
    role = db.StringProperty(choices=["User", "admin", "privileged"],
                             default="User")

    @staticmethod
    def GetUserRole(name):
       user_record = db.GqlQuery("SELECT * from UserRole WHERE " +
                                  "name = :1",
                                  name)).get()
       if user_record != None:
         return user.role
       else:
	     return "User"
#END: UserRoles    

#START: ValidateRole
def ValidateUserRole(actual, required):
    if required == "admin": 
        return actual == "admin"
    elif required == "privileged": 
        return (actual == "admin" || actual == "privileged")
    elif required == "User":
	    return True
	else: 
        return False
#END: ValidateRole

#START: NewChatRoom
class NewChatRoomHandler(webapp.RequestHandler):
  @login_required 
  def get(self):
    user = users.get_current_user()
    role = GetUserRole(user) 
    if not ValidateRole(role, "privileged"):
        self.response.headers["Context-Type"] = "text/html"
        self.response.out.write(
            "<html><head>\n" +
            "<title>Niewystarczające przywileje</title>\n" +
            "</head>\n" +
            "<body><h1>Niewystarczające przywileje</h1>\n" +
            "<p> Przykro nam, ale nie masz praw dostępu " +
            "do tej strony</p>\n" +
            "</body></html>\n")
    else:
      self.response.headers["Content-Type"] = "text/html"
      template_values = {
        'title': "Pokój czatu MarkCC",
        }
      path = os.path.join(os.path.dirname(__file__), 'new-chat.html')
      page = template.render(path, template_values)
      self.response.out.write(page)
#END: NewChatRoom

#START: NewChatRoomPost
class NewChatRoomPostHandler(webapp.RequestHandler):
  @login_required
  def post(self):
    user = users.get_current_user()
    role = GetUserRole(user) 
    if not ValidateRole(role, "privileged"):
        self.response.headers["Context-Type"] = "text/html"
        self.response.out.write(
            "<html><head><title>Niewystarczające przywileje</title></head>\n" +
            "<body><h1>Niewystarczające przywileje</h1>\n" +
            "<p> Przykro nam, ale nie masz praw dostępu do tej strony</p>\n" +
            "</body></html>\n")
    else:
        newchat = cgi.escape(self.request.get("newchat"))
        CreateChat(user, newchat)
        self.response.out.write(
            "<html><head><title>Stworzono nowy pokój czatu</title></head>\n" +
            "<body><h1>Stworzono nowy pokój czatu</h1>\n" +
            "<p> Stworzono pokój %s.</p>\n" 
            "</body></html>\n" % newchat)
#END: NewChatRoomPost

#START: GenericChat
class GenericChatPage(webapp.RequestHandler):
  def get(self):
    requested_chat = self.request.get("chat", default_value="none")
    if requested_chat == "none" or requested_chat not in CHATS:
      template_params = {
          'title': "Error! Requested chat not found!",
          'chatname': requested_chat,
          }
      error_template = os.path.join(os.path.dirname(__file__), 'error.html')
      page = template.render(error_template, template_params)
      self.response.out.write(page)
    else:
      messages = db.GqlQuery("SELECT * from ChatMessage WHERE chat = :1 "
                             "ORDER BY time", requested_chat)
      template_params = {
          'title': "Pokój czatu MarkCC w App Engine",
          'msg_list': messages,
          'chat': requested_chat
          }
      path = os.path.join(os.path.dirname(__file__), 'multichat.html')
      page = template.render(path, template_params)
      self.response.out.write(page)
#END: GenericChat    

#START: ChatRoomCounted
class ChatRoomCountedHandler(webapp.RequestHandler):
  def get(self):
    user = users.get_current_user()
    if user is None: 
      self.redirect(users.create_login_url(self.request.uri))
    else:
      self.response.headers["Content-Type"] = "text/html"
      messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY time "
                             "DESC LIMIT 20")
      msglist = list(messages).reverse()
      for msg in msglist:
        msg.deltatime = datetime.datetime.now() - msg.timestamp
      template_values = {
        'title': "Pokój czatu MarkCC w App Engine",
        'msg_list': messages,
        }
      path = os.path.join(os.path.dirname(__file__), 'count.html')
      page = template.render(path, template_values)
      self.response.out.write(page)
#END: ChatRoomCounted


#START: LandingPage
class ChatRoomLandingPage(webapp.RequestHandler):
  def get(self):
    user = users.get_current_user()
    if user is None: 
      self.redirect(users.create_login_url(self.request.uri))
    else:
      self.response.headers["Content-Type"] = "text/html"
      messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY time "
                             "DESC LIMIT 20")
      messages.reverse()
      template_values = {
        'title': "Pokój czatu MarkCC w App Engine",
        'msg_list': messages,
        }
      path = os.path.join(os.path.dirname(__file__), 'chat.html')
      page = template.render(path, template_values)
      self.response.out.write(page)
#END: LandingPage

#START: ChatRoomPoster
class ChatRoomPoster(webapp.RequestHandler):
  def post(self):
    user = users.get_current_user()
    msgtext = self.request.get("message")
    chat = self.request.get("chat")
    msg = ChatMessage(user=user.nickname(), message=msgtext, chat=chat)
    msg.put() 
    # Now that we've added the message to the chat, we'll redirect
    # to the root page,
    self.redirect('/enterchat&chat=%s' % chat)
#END: ChatRoomPoster

# START: Frame
chatapp = webapp.WSGIApplication([('/', ChatRoomLandingPage),
                                  ('/talk', ChatRoomPoster),
                                  ('/enterchat', GenericChatPage)])

# END: Frame
def main():
    run_wsgi_app(chatapp)

if __name__ == "__main__":
    main()
