/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Log2;
import com.google.appengine.repackaged.com.google.common.base.Log2Logger;
import com.google.appengine.repackaged.com.google.common.base.Logger;
import com.google.appengine.repackaged.com.google.common.base.RotatingLog;
import com.google.common.annotations.GoogleInternal;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

@Deprecated
@GoogleInternal
public class LogWriter
implements Logger {
    private static final char[] LEVEL_ID = new char[]{'D', 'I', 'X'};
    protected static final int defaultThreshold = 0;
    protected int threshold;
    protected SimpleDateFormat dateFormatter = null;
    protected Writer writer = null;
    private Logger javaLogger = null;
    ThreadLocal<String> threadTagMap = new ThreadLocal();

    public LogWriter(Writer writer) {
        this(writer, new SimpleDateFormat("yyMMdd HH:mm:ss.SSS"));
    }

    public LogWriter(Writer writer, SimpleDateFormat dateFormatter) {
        this.writer = writer;
        this.dateFormatter = dateFormatter;
        this.threshold = 0;
    }

    protected LogWriter() {
    }

    public void setThreshold(int level) {
        if (level < 0 || level > 3) {
            throw new RuntimeException("RotatingLog#setThreshold(int) : invalid threshold value: " + level);
        }
        this.threshold = level;
        if (this.javaLogger != null) {
            this.javaLogger.setThreshold(level);
        }
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void logDebug(String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logDebug(msg);
        } else {
            this.write(0, msg);
        }
    }

    public void logEvent(String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logEvent(msg);
        } else {
            this.write(1, msg);
        }
    }

    public void logTimedEvent(String msg, long start, long end) {
        if (this.javaLogger != null) {
            this.javaLogger.logTimedEvent(msg, start, end);
        } else {
            this.write(1, end - start + " ms.: " + msg);
        }
    }

    public void setErrorEmail(String emailAddr) {
    }

    public void logException(Throwable t) {
        this.logException(t, "");
    }

    public void logException(Throwable t, String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logException(t, msg);
        } else {
            String errorMessage = t.getMessage();
            if (errorMessage != null) {
                msg = msg + ": " + errorMessage;
            }
            this.write(2, msg + "\n" + Log2.getExceptionTrace(t));
        }
    }

    public void logSevereException(Throwable t) {
        this.logSevereException(t, "");
    }

    public void logSevereException(Throwable t, String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logSevereException(t, msg);
        } else {
            String errorMessage = t.getMessage();
            if (errorMessage != null) {
                msg = msg + ": " + errorMessage;
            }
            this.write(2, msg + "\n" + Log2.getExceptionTrace(t));
        }
    }

    public void logError(String msg) {
        if (this.javaLogger != null) {
            this.javaLogger.logError(msg);
        } else {
            this.write(2, msg + "\n" + Log2.getExceptionTrace(new LoggedError()));
        }
    }

    protected synchronized void write(int level, String msg) {
        if (level < this.threshold) {
            return;
        }
        String threadTag = this.getThreadTag();
        threadTag = threadTag == null ? "" : threadTag + " ";
        int charPrefix = LEVEL_ID[level];
        StringTokenizer tokenizer = new StringTokenizer(msg, "\n");
        StringBuffer sb = new StringBuffer(1000);
        while (tokenizer.hasMoreTokens()) {
            if (this.dateFormatter != null) {
                sb.append(this.dateFormatter.format(new Date()));
                sb.append(':');
            }
            sb.append((char)charPrefix);
            sb.append(' ');
            sb.append(threadTag);
            sb.append(tokenizer.nextToken());
            sb.append("\n");
            charPrefix = 32;
        }
        try {
            this.writer.write(sb.toString());
            this.writer.flush();
        }
        catch (IOException ioE) {
            System.err.println("LogWriter#write(int, String) : error in writing to log!\n Exception thrown: " + ioE.getMessage() + "\nlog entry: " + msg);
        }
    }

    public String getThreadTag() {
        if (this.javaLogger != null) {
            return this.javaLogger.getThreadTag();
        }
        return this.threadTagMap.get();
    }

    public void setThreadTag(String s) {
        if (this.javaLogger != null) {
            this.javaLogger.setThreadTag(s);
        } else {
            this.threadTagMap.set(s);
        }
    }

    public void close() {
        if (this.javaLogger != null) {
            this.javaLogger.close();
            return;
        }
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createAndSetJavaLogger(String fileName, String linkName, String extension, DateFormat recordTsFormat, DateFormat fileNameTsFormat, long rotationSize) {
        this.javaLogger = new Log2Logger(fileName, linkName, extension, recordTsFormat, fileNameTsFormat, rotationSize);
        this.javaLogger.setThreshold(0);
    }

    public static void main(String[] args) {
        try {
            final RotatingLog lg = new RotatingLog(args[0], 4000L);
            int i = 0;
            while (i < 10) {
                final int j = i++;
                new Thread(){

                    public void run() {
                        lg.setThreadTag("[" + j + "]");
                        lg.logEvent("this is an event");
                        lg.logDebug("this is a debug message");
                        lg.logError("this is an error");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                        lg.logException(new Exception("this is an exception"));
                        lg.logException(new Exception("this is an exception"), "with a message");
                    }
                }.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    static class LoggedError
    extends Throwable {
        private static final long serialVersionUID = 1L;

        LoggedError() {
        }
    }
}

