/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Equivalence;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AsynchronousComputationException;
import com.google.appengine.repackaged.com.google.common.collect.ComputationException;
import com.google.appengine.repackaged.com.google.common.collect.CustomConcurrentHashMap;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import com.google.appengine.repackaged.com.google.common.collect.NullOutputException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComputingConcurrentHashMap<K, V>
extends CustomConcurrentHashMap<K, V>
implements MapMaker.Cache<K, V> {
    final Function<? super K, ? extends V> computingFunction;
    private static final long serialVersionUID = 0L;

    ComputingConcurrentHashMap(MapMaker builder, Function<? super K, ? extends V> computingFunction) {
        super(builder);
        this.computingFunction = Preconditions.checkNotNull(computingFunction);
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V apply(K key) {
        Preconditions.checkNotNull(key);
        int hash = this.hash(key);
        CustomConcurrentHashMap.Segment segment = this.segmentFor(hash);
        block12: while (true) {
            CustomConcurrentHashMap.ReferenceEntry entry;
            if ((entry = segment.getEntry(key, hash)) == null) {
                boolean created = false;
                segment.lock();
                try {
                    if (this.expires) {
                        segment.expireEntries();
                    }
                    if ((entry = segment.getEntry(key, hash)) == null) {
                        created = true;
                        int count = segment.count;
                        if (count++ > segment.threshold) {
                            segment.expand();
                        }
                        AtomicReferenceArray table = segment.table;
                        int index = hash & table.length() - 1;
                        CustomConcurrentHashMap.ReferenceEntry first = table.get(index);
                        ++segment.modCount;
                        entry = this.entryFactory.newEntry(this, key, hash, first);
                        table.set(index, entry);
                        segment.count = count;
                    }
                }
                finally {
                    segment.unlock();
                }
                if (created) {
                    boolean success = false;
                    try {
                        Object value = this.compute(segment, key, entry);
                        Preconditions.checkNotNull(value, "compute() returned null unexpectedly");
                        success = true;
                        Object v = value;
                        return v;
                    }
                    finally {
                        if (!success) {
                            segment.removeEntry(entry, hash);
                        }
                    }
                }
            }
            boolean interrupted = false;
            while (true) {
                try {
                    Object value = this.waitForValue(entry);
                    if (value == null) {
                        segment.removeEntry(entry, hash);
                        continue block12;
                    }
                    Object v = value;
                    return v;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setValueReference(CustomConcurrentHashMap.ReferenceEntry<K, V> entry, CustomConcurrentHashMap.ValueReference<K, V> valueReference) {
        boolean notifyOthers = entry.getValueReference() == UNSET;
        entry.setValueReference(valueReference);
        if (notifyOthers) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry = entry;
            synchronized (referenceEntry) {
                entry.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitForValue(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) throws InterruptedException {
        CustomConcurrentHashMap.ValueReference<K, V> valueReference = entry.getValueReference();
        if (valueReference == UNSET) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry = entry;
            synchronized (referenceEntry) {
                while ((valueReference = entry.getValueReference()) == UNSET) {
                    entry.wait();
                }
            }
        }
        return valueReference.waitForValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V compute(CustomConcurrentHashMap.Segment segment, K key, CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
        V value;
        try {
            value = this.computingFunction.apply(key);
        }
        catch (ComputationException e) {
            this.setValueReference(entry, new ComputationExceptionReference(e.getCause()));
            throw e;
        }
        catch (Throwable t) {
            this.setValueReference(entry, new ComputationExceptionReference(t));
            throw new ComputationException(t);
        }
        if (value == null) {
            String message = this.computingFunction + " returned null for key " + key + ".";
            this.setValueReference(entry, new NullOutputExceptionReference(message));
            throw new NullOutputException(message);
        }
        if (this.expires) {
            segment.lock();
            try {
                segment.setValue(entry, value, true);
            }
            finally {
                segment.unlock();
            }
        } else {
            segment.setValue(entry, value, true);
        }
        return value;
    }

    @Override
    CustomConcurrentHashMap.ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap.ReferenceEntry<K, V> original, CustomConcurrentHashMap.ReferenceEntry<K, V> newNext) {
        CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry = this.entryFactory.copyEntry(this, original, newNext);
        CustomConcurrentHashMap.ValueReference<K, V> valueReference = original.getValueReference();
        if (valueReference == UNSET) {
            newEntry.setValueReference(new FutureValueReference(original, newEntry));
        } else {
            newEntry.setValueReference(valueReference.copyFor(newEntry));
        }
        return newEntry;
    }

    @Override
    Object writeReplace() {
        return new ComputingSerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expirationNanos, this.maximumSize, this.concurrencyLevel, this, this.computingFunction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingSerializationProxy<K, V>
    extends CustomConcurrentHashMap.AbstractSerializationProxy<K, V> {
        final Function<? super K, ? extends V> computingFunction;
        transient MapMaker.Cache<K, V> cache;
        private static final long serialVersionUID = 0L;

        ComputingSerializationProxy(CustomConcurrentHashMap.Strength keyStrength, CustomConcurrentHashMap.Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, long expirationNanos, int maximumSize, int concurrencyLevel, ConcurrentMap<K, V> delegate, Function<? super K, ? extends V> computingFunction) {
            super(keyStrength, valueStrength, keyEquivalence, valueEquivalence, expirationNanos, maximumSize, concurrencyLevel, delegate);
            this.computingFunction = computingFunction;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            this.writeMapTo(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.cache = mapMaker.makeCache(this.computingFunction);
            this.delegate = this.cache.asMap();
            this.readEntries(in);
        }

        Object readResolve() {
            return this.cache;
        }

        public ConcurrentMap<K, V> asMap() {
            return this.delegate;
        }

        public V apply(@Nullable K from) {
            return (V)this.cache.apply(from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FutureValueReference
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final CustomConcurrentHashMap.ReferenceEntry<K, V> original;
        final CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry;

        FutureValueReference(CustomConcurrentHashMap.ReferenceEntry<K, V> original, CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry) {
            this.original = original;
            this.newEntry = newEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            boolean success = false;
            try {
                Object value = this.original.getValueReference().get();
                success = true;
                Object v = value;
                return v;
            }
            finally {
                if (!success) {
                    this.removeEntry();
                }
            }
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return new FutureValueReference(this.original, entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue() throws InterruptedException {
            boolean success = false;
            try {
                Object value = ComputingConcurrentHashMap.this.waitForValue(this.original);
                success = true;
                Object v = value;
                return v;
            }
            finally {
                if (!success) {
                    this.removeEntry();
                }
            }
        }

        void removeEntry() {
            ComputingConcurrentHashMap.this.removeEntry(this.newEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputationExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final Throwable t;

        ComputationExceptionReference(Throwable t) {
            this.t = t;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new AsynchronousComputationException(this.t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullOutputExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final String message;

        NullOutputExceptionReference(String message) {
            this.message = message;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new NullOutputException(this.message);
        }
    }
}

