/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.lang.reflect.Method;

public final class RPCRequest {
    private final int flags;
    private final Method method;
    private final Object[] parameters;
    private final SerializationPolicy serializationPolicy;

    public RPCRequest(Method method, Object[] parameters, SerializationPolicy serializationPolicy, int flags) {
        this.method = method;
        this.parameters = parameters;
        this.serializationPolicy = serializationPolicy;
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public SerializationPolicy getSerializationPolicy() {
        return this.serializationPolicy;
    }

    public String toString() {
        StringBuilder callSignature = new StringBuilder();
        callSignature.append(this.method.getDeclaringClass().getName());
        callSignature.append('.');
        callSignature.append(this.method.getName());
        callSignature.append('(');
        for (Object param : this.parameters) {
            if (param instanceof String) {
                callSignature.append('\"');
                String strParam = (String)param;
                String escapedStrParam = strParam.replaceAll("\\\"", "\\\\\"");
                callSignature.append(escapedStrParam);
                callSignature.append('\"');
            } else if (param == null) {
                callSignature.append("null");
            } else {
                callSignature.append(param.toString());
            }
            callSignature.append(", ");
        }
        int length = callSignature.length();
        callSignature.delete(length - 2, length);
        callSignature.append(')');
        return callSignature.toString();
    }
}

