/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.DatastoreService;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.EmulatedXAResource;
import org.datanucleus.util.NucleusLogger;

class DatastoreXAResource
extends EmulatedXAResource {
    private final DatastoreService datastoreService;
    private DatastoreTransaction currentTxn;

    public DatastoreXAResource(DatastoreService datastoreService) {
        this.datastoreService = datastoreService;
    }

    DatastoreTransaction getCurrentTransaction() {
        return this.currentTxn;
    }

    public void start(Xid xid, int flags) throws XAException {
        super.start(xid, flags);
        if (this.currentTxn != null) {
            throw new XAException("Nested transactions are not supported");
        }
        this.currentTxn = new DatastoreTransaction(this.datastoreService.beginTransaction());
        NucleusLogger.DATASTORE.debug((Object)("Started new datastore transaction: " + this.currentTxn.getInnerTxn().getId()));
    }

    public void commit(Xid arg0, boolean arg1) throws XAException {
        super.commit(arg0, arg1);
        if (this.currentTxn == null) {
            throw new XAException("A transaction has not been started, cannot commit");
        }
        this.currentTxn.commit();
        NucleusLogger.DATASTORE.debug((Object)("Committed datastore transaction: " + this.currentTxn.getInnerTxn().getId()));
        this.currentTxn = null;
    }

    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        if (this.currentTxn == null) {
            throw new XAException("A transaction has not been started, cannot roll back");
        }
        this.currentTxn.rollback();
        NucleusLogger.DATASTORE.debug((Object)("Rolled back datastore transaction: " + this.currentTxn.getInnerTxn().getId()));
        this.currentTxn = null;
    }
}

