/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.api.labs.taskqueue.QueueConstants;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.UnsupportedTranslationException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOptions
implements Serializable {
    private String taskName;
    private byte[] payload;
    private HashMap<String, List<String>> headers;
    private Method method;
    private List<Param> params;
    private String url;
    private Long countdownMillis;
    private Long etaMillis;

    private TaskOptions() {
        this.method = Method.POST;
        this.headers = new LinkedHashMap<String, List<String>>();
        this.params = new LinkedList<Param>();
    }

    public TaskOptions(TaskOptions options) {
        this.taskName = options.taskName;
        this.method = options.method;
        this.url = options.url;
        this.countdownMillis = options.countdownMillis;
        this.etaMillis = options.etaMillis;
        this.payload(options.getPayload());
        this.initializeHeaders(options.getHeaders());
        this.initializeParams(options.getParams());
    }

    private void initializeHeaders(Map<String, List<String>> headers) {
        this.headers = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            this.headers.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
    }

    private void initializeParams(List<Param> params) {
        this.params = new LinkedList<Param>(params);
    }

    Method getMethod() {
        return this.method;
    }

    public TaskOptions taskName(String taskName) {
        if (taskName != null && taskName.length() != 0 && !QueueConstants.TASK_NAME_PATTERN.matcher(taskName).matches()) {
            throw new IllegalArgumentException("Task name does not match expression " + QueueConstants.TASK_NAME_REGEX + "; given taskname: '" + taskName + "'");
        }
        this.taskName = taskName;
        return this;
    }

    String getTaskName() {
        return this.taskName;
    }

    byte[] getPayload() {
        return this.payload;
    }

    TaskOptions payload(byte[] payload) {
        this.payload = (byte[])payload.clone();
        return this;
    }

    public TaskOptions payload(String payload, String charset) {
        try {
            return this.payload(payload.getBytes(charset), "text/plain; charset=" + charset);
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException("Unsupported charset '" + charset + "' requested.", exception);
        }
    }

    public TaskOptions payload(byte[] payload, String contentType) {
        return this.payload(payload).header("content-type", contentType);
    }

    public TaskOptions payload(String payload) {
        return this.payload(payload, "UTF-8");
    }

    HashMap<String, List<String>> getHeaders() {
        return this.headers;
    }

    public TaskOptions headers(Map<String, String> headers) {
        this.headers = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ArrayList<String> values = new ArrayList<String>(1);
            values.add(entry.getValue());
            this.headers.put(entry.getKey(), values);
        }
        return this;
    }

    public TaskOptions header(String headerName, String value) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("header(name, <null>) is not allowed.");
        }
        if (!this.headers.containsKey(headerName)) {
            this.headers.put(headerName, new ArrayList());
        }
        this.headers.get(headerName).add(value);
        return this;
    }

    public TaskOptions removeHeader(String headerName) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty.");
        }
        this.headers.remove(headerName);
        return this;
    }

    public TaskOptions method(Method method) {
        this.method = method;
        return this;
    }

    List<Param> getParams() {
        return this.params;
    }

    TaskOptions param(Param param) {
        this.params.add(param);
        return this;
    }

    public TaskOptions param(String name, String value) {
        return this.param(new StringValueParam(name, value));
    }

    public TaskOptions param(String name, byte[] value) {
        return this.param(new ByteArrayValueParam(name, value));
    }

    public TaskOptions removeParam(String paramName) {
        if (paramName == null || paramName.length() == 0) {
            throw new IllegalArgumentException("paramName must not be null or empty.");
        }
        Iterator<Param> paramsIter = this.params.iterator();
        while (paramsIter.hasNext()) {
            if (paramsIter.next().name != paramName) continue;
            paramsIter.remove();
        }
        return this;
    }

    String getUrl() {
        return this.url;
    }

    public TaskOptions url(String url) {
        if (url == null) {
            throw new IllegalArgumentException("null url is not allowed.");
        }
        this.url = url;
        return this;
    }

    Long getCountdownMillis() {
        return this.countdownMillis;
    }

    public TaskOptions countdownMillis(long countdownMillis) {
        this.countdownMillis = countdownMillis;
        return this;
    }

    Long getEtaMillis() {
        return this.etaMillis;
    }

    public TaskOptions etaMillis(long etaMillis) {
        this.etaMillis = etaMillis;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        public static TaskOptions taskName(String taskName) {
            return Builder.withDefaults().taskName(taskName);
        }

        static TaskOptions payload(byte[] payload) {
            return Builder.withDefaults().payload(payload);
        }

        public static TaskOptions payload(String payload, String charset) {
            return Builder.withDefaults().payload(payload, charset);
        }

        public static TaskOptions payload(byte[] payload, String contentType) {
            return Builder.withDefaults().payload(payload, contentType);
        }

        public static TaskOptions payload(String payload) {
            return Builder.withDefaults().payload(payload);
        }

        public static TaskOptions headers(Map<String, String> headers) {
            return Builder.withDefaults().headers(headers);
        }

        public static TaskOptions header(String headerName, String value) {
            return Builder.withDefaults().header(headerName, value);
        }

        public static TaskOptions method(Method method) {
            return Builder.withDefaults().method(method);
        }

        public static TaskOptions param(String paramName, String value) {
            return Builder.withDefaults().param(paramName, value);
        }

        public static TaskOptions param(String paramName, byte[] value) {
            return Builder.withDefaults().param(paramName, value);
        }

        public static TaskOptions url(String url) {
            return Builder.withDefaults().url(url);
        }

        public static TaskOptions countdownMillis(long countdownMillis) {
            return Builder.withDefaults().countdownMillis(countdownMillis);
        }

        public static TaskOptions etaMillis(long etaMillis) {
            return Builder.withDefaults().etaMillis(etaMillis);
        }

        public static TaskOptions withDefaults() {
            return new TaskOptions();
        }

        private Builder() {
        }
    }

    static class ByteArrayValueParam
    extends Param {
        protected final byte[] value;

        ByteArrayValueParam(String name, byte[] value) {
            super(name);
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteArrayValueParam)) {
                return false;
            }
            ByteArrayValueParam that = (ByteArrayValueParam)o;
            return Arrays.equals(this.value, that.value) && this.name.equals(that.name);
        }

        public String getURLEncodedValue() throws UnsupportedEncodingException {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.value.length; ++i) {
                result.append("%");
                char character = Character.toUpperCase(Character.forDigit(this.value[i] >> 4 & 0xF, 16));
                result.append(character);
                character = Character.toUpperCase(Character.forDigit(this.value[i] & 0xF, 16));
                result.append(character);
            }
            return result.toString();
        }
    }

    static class StringValueParam
    extends Param {
        protected final String value;

        StringValueParam(String name, String value) {
            super(name);
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringValueParam)) {
                return false;
            }
            StringValueParam that = (StringValueParam)o;
            return this.value.equals(that.value) && this.name.equals(that.name);
        }

        public String getURLEncodedValue() throws UnsupportedEncodingException {
            return StringValueParam.encodeURLAsUtf8(this.value);
        }
    }

    static abstract class Param {
        protected final String name;

        public Param(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("name must not be null or empty");
            }
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        protected static String encodeURLAsUtf8(String url) throws UnsupportedEncodingException {
            return URLEncoder.encode(url, "UTF-8");
        }

        public abstract boolean equals(Object var1);

        public String getURLEncodedName() throws UnsupportedEncodingException {
            return Param.encodeURLAsUtf8(this.name);
        }

        abstract String getURLEncodedValue() throws UnsupportedEncodingException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        DELETE(TaskQueuePb.TaskQueueAddRequest.RequestMethod.DELETE, false),
        GET(TaskQueuePb.TaskQueueAddRequest.RequestMethod.GET, false),
        HEAD(TaskQueuePb.TaskQueueAddRequest.RequestMethod.HEAD, false),
        POST(TaskQueuePb.TaskQueueAddRequest.RequestMethod.POST, true),
        PUT(TaskQueuePb.TaskQueueAddRequest.RequestMethod.PUT, true);

        private TaskQueuePb.TaskQueueAddRequest.RequestMethod pbMethod;
        private boolean isBodyMethod;

        private Method(TaskQueuePb.TaskQueueAddRequest.RequestMethod pbMethod, boolean isBodyMethod) {
            this.pbMethod = pbMethod;
            this.isBodyMethod = isBodyMethod;
        }

        TaskQueuePb.TaskQueueAddRequest.RequestMethod getPbMethod() {
            return this.pbMethod;
        }

        boolean supportsBody() {
            return this.isBodyMethod;
        }
    }
}

