/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.labs.taskqueue.InternalFailureException;
import com.google.appengine.api.labs.taskqueue.QueueFailureException;
import com.google.appengine.api.labs.taskqueue.TaskAlreadyExistsException;
import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.TransactionalTaskException;
import com.google.appengine.api.labs.taskqueue.TransientFailureException;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueueApiHelper {
    static final String PACKAGE = "taskqueue";

    QueueApiHelper() {
    }

    <T extends ProtocolMessage<T>, V extends ProtocolMessage<V>> void makeSyncCall(String method, ProtocolMessage<T> request, ProtocolMessage<V> response) {
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall((String)PACKAGE, (String)method, (byte[])request.toByteArray());
            if (responseBytes != null) {
                response.mergeFrom(responseBytes);
            }
        }
        catch (ApiProxy.ApplicationException exception) {
            throw QueueApiHelper.translateError(exception);
        }
    }

    static RuntimeException translateError(ApiProxy.ApplicationException exception) {
        int applicationError = exception.getApplicationError();
        TaskQueuePb.TaskQueueServiceError.ErrorCode errorCode = TaskQueuePb.TaskQueueServiceError.ErrorCode.valueOf(applicationError);
        String detail = exception.getErrorDetail();
        int datastoreErrorCode = TaskQueuePb.TaskQueueServiceError.ErrorCode.DATASTORE_ERROR.getValue();
        if (applicationError >= datastoreErrorCode) {
            ApiProxy.ApplicationException datastoreApplicationException = new ApiProxy.ApplicationException(applicationError - datastoreErrorCode, detail);
            TransactionalTaskException taskqueueException = new TransactionalTaskException();
            taskqueueException.initCause(DatastoreApiHelper.translateError((ApiProxy.ApplicationException)datastoreApplicationException));
            return taskqueueException;
        }
        switch (errorCode) {
            case UNKNOWN_QUEUE: {
                return new IllegalStateException("The specified queue is unknown : " + detail);
            }
            case TRANSIENT_ERROR: {
                return new TransientFailureException(detail);
            }
            case INTERNAL_ERROR: {
                return new InternalFailureException(detail);
            }
            case TASK_TOO_LARGE: {
                return new IllegalArgumentException("Task size is too large : " + detail);
            }
            case INVALID_TASK_NAME: {
                return new IllegalArgumentException("Invalid task name : " + detail);
            }
            case INVALID_QUEUE_NAME: {
                return new IllegalArgumentException("Invalid queue name : " + detail);
            }
            case INVALID_URL: {
                return new IllegalArgumentException("Invalud URL : " + detail);
            }
            case INVALID_QUEUE_RATE: {
                return new IllegalArgumentException("Invalid queue rate : " + detail);
            }
            case PERMISSION_DENIED: {
                return new SecurityException("Permission for requested operation is denied:" + detail);
            }
            case TASK_ALREADY_EXISTS: {
                return new TaskAlreadyExistsException("Task name already exists : " + detail);
            }
            case TOMBSTONED_TASK: {
                return new TaskAlreadyExistsException("Task name is tombstoned : " + detail);
            }
            case INVALID_ETA: {
                return new IllegalArgumentException("ETA is invalid : " + detail);
            }
            case INVALID_REQUEST: {
                return new IllegalArgumentException("Invalid request : " + detail);
            }
            case UNKNOWN_TASK: {
                return new QueueFailureException("Unspecified error (" + (Object)((Object)errorCode) + ") : " + detail);
            }
            case TOMBSTONED_QUEUE: {
                return new IllegalStateException("The queue has been marked for deletion and is no longer usable : " + detail);
            }
        }
        return new QueueFailureException("Unspecified error (" + (Object)((Object)errorCode) + ") : " + detail);
    }
}

