/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Transaction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastorePersistenceHandler;
import org.datanucleus.store.appengine.DatastoreServiceFactoryInternal;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.DatastoreTransaction;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.PrimitiveArrays;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.ProjectionResultTransformer;
import org.datanucleus.store.appengine.query.RuntimeExceptionWrappingIterable;
import org.datanucleus.store.appengine.query.StreamingQueryResult;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreQuery
implements Serializable {
    static final Expression.Operator GROUP_BY_OP = new Expression.Operator("GROUP BY", Integer.MAX_VALUE);
    static final Expression.Operator HAVING_OP = new Expression.Operator("HAVING", Integer.MAX_VALUE);
    static final Expression.Operator JOIN_OP = new Expression.Operator("JOIN", Integer.MAX_VALUE);
    static final Set<Expression.Operator> UNSUPPORTED_OPERATORS = Utils.newHashSet(Expression.OP_ADD, Expression.OP_COM, Expression.OP_CONCAT, Expression.OP_DIV, Expression.OP_IS, Expression.OP_ISNOT, Expression.OP_LIKE, Expression.OP_MOD, Expression.OP_NEG, Expression.OP_MUL, Expression.OP_NOT, Expression.OP_OR, Expression.OP_SUB);
    private static final Map<Expression.Operator, Query.FilterOperator> DATANUCLEUS_OP_TO_APPENGINE_OP = DatastoreQuery.buildNewOpMap();
    private final AbstractJavaQuery query;
    private transient com.google.appengine.api.datastore.Query latestDatastoreQuery;
    public static NowProvider NOW_PROVIDER = new NowProvider(){

        public Date now() {
            return new Date();
        }
    };

    private static Map<Expression.Operator, Query.FilterOperator> buildNewOpMap() {
        HashMap<Expression.Operator, Query.FilterOperator> map = new HashMap<Expression.Operator, Query.FilterOperator>();
        map.put((Expression.Operator)Expression.OP_EQ, Query.FilterOperator.EQUAL);
        map.put((Expression.Operator)Expression.OP_GT, Query.FilterOperator.GREATER_THAN);
        map.put((Expression.Operator)Expression.OP_GTEQ, Query.FilterOperator.GREATER_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_LT, Query.FilterOperator.LESS_THAN);
        map.put((Expression.Operator)Expression.OP_LTEQ, Query.FilterOperator.LESS_THAN_OR_EQUAL);
        map.put((Expression.Operator)Expression.OP_NOTEQ, Query.FilterOperator.GREATER_THAN);
        return map;
    }

    private boolean isBulkDelete() {
        return this.query.getType() == 2;
    }

    public DatastoreQuery(AbstractJavaQuery query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object performExecute(Localiser localiser, QueryCompilation compilation, long fromInclNo, long toExclNo, Map<String, ?> parameters) {
        ObjectManager om = this.getObjectManager();
        DatastoreManager storeMgr = this.getStoreManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(this.query.getCandidateClass(), clr);
        if (acmd == null) {
            throw new NucleusUserException("No meta data for " + this.query.getCandidateClass().getName() + ".  Perhaps you need to run the enhancer on this class?").setFatal();
        }
        storeMgr.validateMetaDataForClass(acmd, clr);
        DatastoreTable table = storeMgr.getDatastoreClass(acmd.getFullClassName(), clr);
        QueryData qd = this.validate(compilation, parameters, acmd, table, clr);
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)localiser.msg("021046", (Object)"DATASTORE", (Object)this.query.getSingleStringQuery(), null));
        }
        if (toExclNo == 0L || this.rangeValueIsSet(toExclNo) && this.rangeValueIsSet(fromInclNo) && toExclNo - fromInclNo <= 0L) {
            return Collections.emptyList();
        }
        this.addFilters(qd);
        this.addSorts(qd);
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService();
        ManagedConnection mconn = this.getStoreManager().getConnection(this.getObjectManager());
        try {
            if (qd.batchGetKeys != null) {
                Object object = this.fulfillBatchGetQuery(ds, qd, mconn);
                return object;
            }
            this.latestDatastoreQuery = qd.datastoreQuery;
            Transaction txn = null;
            Map extensions = this.query.getExtensions();
            if (extensions == null || !extensions.containsKey("gae.exclude-query-from-txn") || !((Boolean)extensions.get("gae.exclude-query-from-txn")).booleanValue()) {
                txn = qd.datastoreQuery.getAncestor() != null ? ds.getCurrentTransaction(null) : null;
            }
            PreparedQuery preparedQuery = ds.prepare(txn, qd.datastoreQuery);
            FetchOptions opts = this.buildFetchOptions(fromInclNo, toExclNo);
            if (qd.resultType == ResultType.COUNT) {
                List<Integer> list = this.fulfillCountQuery(preparedQuery, opts);
                return list;
            }
            if (qd.resultType == ResultType.KEYS_ONLY || this.isBulkDelete()) {
                qd.datastoreQuery.setKeysOnly();
            }
            Object object = this.fulfillEntityQuery(preparedQuery, opts, qd.resultTransformer, ds, mconn);
            return object;
        }
        finally {
            mconn.release();
        }
    }

    private Object fulfillBatchGetQuery(DatastoreService ds, QueryData qd, ManagedConnection mconn) {
        Transaction innerTxn;
        DatastoreTransaction txn = EntityUtils.getCurrentTransaction(this.getObjectManager());
        Transaction transaction = innerTxn = txn == null ? null : txn.getInnerTxn();
        if (this.isBulkDelete()) {
            return this.fulfillBatchDeleteQuery(innerTxn, ds, qd);
        }
        Collection<Entity> entities = ds.get(innerTxn, (Iterable)qd.batchGetKeys).values();
        if (qd.resultType == ResultType.COUNT) {
            return Collections.singletonList(entities.size());
        }
        return this.newStreamingQueryResultForEntities(entities, qd.resultTransformer, mconn);
    }

    private long fulfillBatchDeleteQuery(Transaction innerTxn, DatastoreService ds, QueryData qd) {
        Set keysToDelete = qd.batchGetKeys;
        Map extensions = this.query.getExtensions();
        if (extensions != null && extensions.containsKey("gae.slow-but-more-accurate-jpql-delete-query") && ((Boolean)extensions.get("gae.slow-but-more-accurate-jpql-delete-query")).booleanValue()) {
            Map getResult = ds.get(innerTxn, (Iterable)qd.batchGetKeys);
            keysToDelete = getResult.keySet();
        }
        ds.delete(innerTxn, (Iterable)keysToDelete);
        return keysToDelete.size();
    }

    private List<Integer> fulfillCountQuery(PreparedQuery preparedQuery, FetchOptions opts) {
        if (opts != null) {
            throw new UnsupportedOperationException("The datastore does not support using count() in conjunction with offset and/or limit.  You can get the answer to this query by issuing the query without count() and then counting the size of the result set.");
        }
        return Collections.singletonList(preparedQuery.countEntities());
    }

    private Object fulfillEntityQuery(PreparedQuery preparedQuery, FetchOptions opts, Utils.Function<Entity, Object> resultTransformer, DatastoreService ds, ManagedConnection mconn) {
        Iterable entities = opts != null ? preparedQuery.asIterable(opts) : preparedQuery.asIterable();
        if (this.isBulkDelete()) {
            return this.deleteEntityQueryResult(entities, ds);
        }
        return this.newStreamingQueryResultForEntities(entities, resultTransformer, mconn);
    }

    private long deleteEntityQueryResult(Iterable<Entity> entities, DatastoreService ds) {
        ArrayList<Object> keysToDelete = Utils.newArrayList(new Object[0]);
        for (Entity e : entities) {
            keysToDelete.add(e.getKey());
        }
        ds.delete(ds.getCurrentTransaction(null), keysToDelete);
        return keysToDelete.size();
    }

    private List<?> newStreamingQueryResultForEntities(Iterable<Entity> entities, Utils.Function<Entity, Object> resultTransformer, final ManagedConnection mconn) {
        final StreamingQueryResult qr = new StreamingQueryResult((Query)this.query, new RuntimeExceptionWrappingIterable(entities), resultTransformer);
        ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

            public void managedConnectionPreClose() {
            }

            public void managedConnectionPostClose() {
            }

            public void managedConnectionFlushed() {
                qr.disconnect();
            }

            public void resourcePostClose() {
                mconn.removeListener((ManagedConnectionResourceListener)this);
            }
        };
        mconn.addListener(listener);
        qr.addConnectionListener(listener);
        return qr;
    }

    private boolean rangeValueIsSet(long rangeVal) {
        return rangeVal != Long.MAX_VALUE;
    }

    FetchOptions buildFetchOptions(long fromInclNo, long toExclNo) {
        FetchOptions opts = null;
        Integer offset = null;
        if (fromInclNo != 0L && this.rangeValueIsSet(fromInclNo)) {
            offset = (int)Math.min(Integer.MAX_VALUE, fromInclNo);
            opts = FetchOptions.Builder.withOffset((int)offset);
        }
        if (this.rangeValueIsSet(toExclNo)) {
            int intExclNo = (int)Math.min(Integer.MAX_VALUE, toExclNo);
            if (opts == null) {
                opts = FetchOptions.Builder.withLimit((int)intExclNo);
            } else {
                opts.limit(intExclNo - offset);
            }
        }
        return opts;
    }

    private Object entityToPojo(Entity entity, AbstractClassMetaData acmd, ClassLoaderResolver clr, DatastoreManager storeMgr, FetchPlan fp) {
        return DatastoreQuery.entityToPojo(entity, acmd, clr, storeMgr, this.getObjectManager(), this.query.getIgnoreCache(), fp);
    }

    public static Object entityToPojo(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, final DatastoreManager storeMgr, ObjectManager om, boolean ignoreCache, final FetchPlan fetchPlan) {
        storeMgr.validateMetaDataForClass(acmd, clr);
        FieldValues fv = new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity));
            }

            public FetchPlan getFetchPlanForLoading() {
                return fetchPlan;
            }
        };
        Object pojo = om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), fv, ignoreCache, true);
        StateManager stateMgr = om.findStateManager(pojo);
        DatastorePersistenceHandler handler = storeMgr.getPersistenceHandler();
        handler.setAssociatedEntity(stateMgr, EntityUtils.getCurrentTransaction(om), entity);
        int[] fieldsToFetch = fetchPlan != null ? fetchPlan.getFetchPlanForClass(acmd).getFieldsInActualFetchPlan() : acmd.getAllMemberPositions();
        storeMgr.getPersistenceHandler().fetchObject(stateMgr, fieldsToFetch);
        return pojo;
    }

    private static Object entityToPojoPrimaryKey(final Entity entity, final AbstractClassMetaData acmd, ClassLoaderResolver clr, final DatastoreManager storeMgr, ObjectManager om) {
        storeMgr.validateMetaDataForClass(acmd, clr);
        FieldValues fv = new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new DatastoreFieldManager(sm, storeMgr, entity));
            }

            public void fetchNonLoadedFields(StateManager sm) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        };
        return om.findObjectUsingAID(clr.classForName(acmd.getFullClassName()), fv, false, true);
    }

    private QueryData validate(QueryCompilation compilation, Map<String, ?> parameters, final AbstractClassMetaData acmd, DatastoreTable table, final ClassLoaderResolver clr) {
        if (this.query.getType() == 1) {
            throw new NucleusUserException("Only select and delete statements are supported.").setFatal();
        }
        if (this.query.getCandidateClass() == null) {
            throw new NucleusUserException("Candidate class could not be found: " + this.query.getSingleStringQuery()).setFatal();
        }
        if (this.query.getGrouping() != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), GROUP_BY_OP);
        }
        if (this.query.getHaving() != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), HAVING_OP);
        }
        if (compilation.getExprFrom() != null) {
            for (Expression fromExpr : compilation.getExprFrom()) {
                this.checkNotJoin(fromExpr);
            }
        }
        final ArrayList<Object> projectionFields = Utils.newArrayList(new Object[0]);
        ResultType resultType = this.validateResultExpression(compilation, acmd, projectionFields);
        String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
        Utils.Function<Object, Object> resultTransformer = resultType == ResultType.KEYS_ONLY ? new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return DatastoreQuery.entityToPojoPrimaryKey(from, acmd, clr, DatastoreQuery.this.getDatastoreManager(), DatastoreQuery.this.getObjectManager());
            }
        } : new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                FetchPlan fp = DatastoreQuery.this.query.getFetchPlan();
                if (!projectionFields.isEmpty()) {
                    fp = null;
                }
                return DatastoreQuery.this.entityToPojo(from, acmd, clr, DatastoreQuery.this.getDatastoreManager(), fp);
            }
        };
        if (!projectionFields.isEmpty()) {
            resultTransformer = new ProjectionResultTransformer(resultTransformer, this.getObjectManager(), projectionFields, this.query.getSingleStringQuery());
        }
        return new QueryData(parameters, acmd, table, compilation, new com.google.appengine.api.datastore.Query(kind), resultType, resultTransformer);
    }

    private ResultType validateResultExpression(QueryCompilation compilation, AbstractClassMetaData acmd, List<AbstractMemberMetaData> projectionFields) {
        ResultType resultType = null;
        if (compilation.getExprResult() != null) {
            for (Expression resultExpr : compilation.getExprResult()) {
                if (resultExpr instanceof InvokeExpression) {
                    InvokeExpression invokeExpr = (InvokeExpression)resultExpr;
                    if (!invokeExpr.getOperation().equals("count")) {
                        Expression.Operator operator = new Expression.Operator(invokeExpr.getOperation(), 0);
                        throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
                    }
                    if (!projectionFields.isEmpty()) {
                        throw this.newAggregateAndRowResultsException();
                    }
                    resultType = ResultType.COUNT;
                    continue;
                }
                if (resultExpr instanceof PrimaryExpression) {
                    PrimaryExpression primaryExpr;
                    if (resultType == ResultType.COUNT) {
                        throw this.newAggregateAndRowResultsException();
                    }
                    if (resultType == null) {
                        resultType = ResultType.KEYS_ONLY;
                    }
                    if ((primaryExpr = (PrimaryExpression)resultExpr).getId().equals(compilation.getCandidateAlias())) continue;
                    AbstractMemberMetaData ammd = this.getMemberMetaData(acmd, this.getTuples(primaryExpr, compilation.getCandidateAlias()));
                    if (ammd == null) {
                        throw this.noMetaDataException(primaryExpr.getId(), acmd.getFullClassName());
                    }
                    projectionFields.add(ammd);
                    if (!(ammd.getParent() instanceof EmbeddedMetaData) && ammd.isPrimaryKey()) continue;
                    resultType = ResultType.ENTITY_PROJECTION;
                    continue;
                }
                Expression.Operator operator = new Expression.Operator(resultExpr.getClass().getName(), 0);
                throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
            }
        }
        if (resultType == null) {
            resultType = ResultType.ENTITY;
        }
        return resultType;
    }

    private UnsupportedDatastoreFeatureException newAggregateAndRowResultsException() {
        return new UnsupportedDatastoreFeatureException("Cannot combine an aggregate results with row results.", this.query.getSingleStringQuery());
    }

    private void checkNotJoin(Expression expr) {
        if (expr instanceof JoinExpression) {
            throw new UnsupportedDatastoreFeatureException("Cannot fulfill queries with joins.", this.query.getSingleStringQuery());
        }
        if (expr.getLeft() != null) {
            this.checkNotJoin(expr.getLeft());
        }
        if (expr.getRight() != null) {
            this.checkNotJoin(expr.getRight());
        }
    }

    private void addSorts(QueryData qd) {
        Expression[] orderBys = qd.compilation.getExprOrdering();
        if (orderBys == null) {
            return;
        }
        for (Expression expr : orderBys) {
            OrderExpression oe = (OrderExpression)expr;
            Query.SortDirection dir = oe.getSortOrder() == null || oe.getSortOrder().equals("ascending") ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING;
            PrimaryExpression left = (PrimaryExpression)oe.getLeft();
            AbstractMemberMetaData ammd = this.getMemberMetaData(qd.acmd, this.getTuples(left, qd.compilation.getCandidateAlias()));
            if (ammd == null) {
                throw this.noMetaDataException(left.getId(), qd.acmd.getFullClassName());
            }
            if (this.isParentPK(ammd)) {
                throw new UnsupportedDatastoreFeatureException("Cannot sort by parent.", this.query.getSingleStringQuery());
            }
            String sortProp = ammd.isPrimaryKey() ? "__key__" : this.determinePropertyName(ammd);
            if (qd.batchGetKeys != null) {
                this.throwInvalidBatchLookupException();
            }
            qd.datastoreQuery.addSort(sortProp, dir);
        }
    }

    IdentifierFactory getIdentifierFactory() {
        return this.getStoreManager().getIdentifierFactory();
    }

    private DatastoreManager getStoreManager() {
        return (DatastoreManager)this.getObjectManager().getStoreManager();
    }

    private void addFilters(QueryData qd) {
        Expression filter = qd.compilation.getExprFilter();
        this.addExpression(filter, qd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addExpression(Expression expr, QueryData qd) {
        if (expr == null) {
            return;
        }
        this.checkForUnsupportedOperator(expr.getOperator());
        if (expr instanceof DyadicExpression) {
            if (expr.getOperator().equals(Expression.OP_AND)) {
                this.addExpression(expr.getLeft(), qd);
                this.addExpression(expr.getRight(), qd);
                return;
            } else {
                if (DATANUCLEUS_OP_TO_APPENGINE_OP.get(expr.getOperator()) == null) {
                    throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), expr.getOperator());
                }
                if (expr.getLeft() instanceof PrimaryExpression) {
                    this.addLeftPrimaryExpression((PrimaryExpression)expr.getLeft(), expr.getOperator(), expr.getRight(), qd);
                    return;
                } else {
                    this.addExpression(expr.getLeft(), qd);
                    this.addExpression(expr.getRight(), qd);
                }
            }
            return;
        } else if (expr instanceof PrimaryExpression) {
            this.addExpression(expr.getLeft(), qd);
            this.addExpression(expr.getRight(), qd);
            return;
        } else {
            if (!(expr instanceof InvokeExpression)) throw new UnsupportedDatastoreFeatureException("Unexpected expression type while parsing query: " + expr.getClass().getName(), this.query.getSingleStringQuery());
            InvokeExpression invocation = (InvokeExpression)expr;
            if (invocation.getOperation().equals("contains") && invocation.getArguments().size() == 1) {
                this.handleContainsOperation(invocation, expr, qd);
                return;
            } else if (invocation.getOperation().equals("startsWith") && invocation.getArguments().size() == 1) {
                this.handleStartsWithOperation(invocation, expr, qd);
                return;
            } else {
                if (!invocation.getOperation().equals("matches") || invocation.getArguments().size() != 1) throw this.newUnsupportedQueryMethodException(invocation);
                this.handleMatchesOperation(invocation, expr, qd);
            }
        }
    }

    private void handleMatchesOperation(InvokeExpression invocation, Expression expr, QueryData qd) {
        Expression param = (Expression)invocation.getArguments().get(0);
        if (expr.getLeft() instanceof PrimaryExpression && param instanceof Literal) {
            String matchesExpr = this.getPrefixFromMatchesExpression(((Literal)param).getLiteral());
            this.addPrefix((PrimaryExpression)expr.getLeft(), (Expression)new Literal((Object)matchesExpr), matchesExpr, qd);
        } else if (expr.getLeft() instanceof PrimaryExpression && param instanceof ParameterExpression) {
            ParameterExpression parameterExpression = (ParameterExpression)param;
            Object parameterValue = this.getParameterValue(qd, parameterExpression);
            String matchesExpr = this.getPrefixFromMatchesExpression(parameterValue);
            this.addPrefix((PrimaryExpression)expr.getLeft(), (Expression)new Literal((Object)matchesExpr), matchesExpr, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invocation);
        }
    }

    private String getPrefixFromMatchesExpression(Object matchesExprObj) {
        if (matchesExprObj instanceof Character) {
            matchesExprObj = matchesExprObj.toString();
        }
        if (!(matchesExprObj instanceof String)) {
            throw new NucleusUserException("Prefix matching only supported on strings (received a " + matchesExprObj.getClass().getName() + ").").setFatal();
        }
        String matchesExpr = (String)matchesExprObj;
        int wildcardIndex = matchesExpr.indexOf(37);
        if (wildcardIndex != matchesExpr.length() - 1) {
            throw new UnsupportedDatastoreFeatureException("Wildcard must appear at the end of the expression string (only prefix matches are supported)", this.query.getSingleStringQuery());
        }
        return matchesExpr.substring(0, wildcardIndex);
    }

    private void addPrefix(PrimaryExpression left, Expression right, String prefix, QueryData qd) {
        this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_GTEQ, right, qd);
        Literal param = this.getUpperLimitForStartsWithStr(prefix);
        this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_LT, (Expression)param, qd);
    }

    private void handleStartsWithOperation(InvokeExpression invocation, Expression expr, QueryData qd) {
        Expression param = (Expression)invocation.getArguments().get(0);
        param.bind();
        if (expr.getLeft() instanceof PrimaryExpression && param instanceof Literal) {
            this.addPrefix((PrimaryExpression)expr.getLeft(), param, (String)((Literal)param).getLiteral(), qd);
        } else if (expr.getLeft() instanceof PrimaryExpression && param instanceof ParameterExpression) {
            Object parameterValue = this.getParameterValue(qd, (ParameterExpression)param);
            this.addPrefix((PrimaryExpression)expr.getLeft(), param, (String)parameterValue, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invocation);
        }
    }

    private void handleContainsOperation(InvokeExpression invocation, Expression expr, QueryData qd) {
        Expression param = (Expression)invocation.getArguments().get(0);
        param.bind();
        if (expr.getLeft() instanceof PrimaryExpression) {
            PrimaryExpression left = (PrimaryExpression)expr.getLeft();
            this.addLeftPrimaryExpression(left, (Expression.Operator)Expression.OP_EQ, param, qd);
        } else if (expr.getLeft() instanceof ParameterExpression && param instanceof PrimaryExpression) {
            ParameterExpression pe = (ParameterExpression)expr.getLeft();
            this.addLeftPrimaryExpression((PrimaryExpression)param, (Expression.Operator)Expression.OP_EQ, (Expression)pe, qd);
        } else {
            throw this.newUnsupportedQueryMethodException(invocation);
        }
    }

    private Literal getUpperLimitForStartsWithStr(String val) {
        byte[] bytes = val.getBytes();
        int i = bytes.length - 1;
        while (i >= 0) {
            byte[] endKey = new byte[i + 1];
            System.arraycopy(bytes, 0, endKey, 0, i + 1);
            int n = i--;
            endKey[n] = (byte)(endKey[n] + 1);
            if (endKey[n] == 0) continue;
            return new Literal((Object)new String(endKey));
        }
        return null;
    }

    private UnsupportedDatastoreFeatureException newUnsupportedQueryMethodException(InvokeExpression invocation) {
        throw new UnsupportedDatastoreFeatureException("Unsupported method <" + invocation.getOperation() + "> while parsing expression: " + invocation, this.query.getSingleStringQuery());
    }

    private Object getParameterValue(QueryData qd, ParameterExpression pe) {
        if (pe.getPosition() != -1 && qd.parameters != null && qd.parameters.get(pe.getPosition()) != null) {
            return qd.parameters.get(pe.getPosition());
        }
        return qd.parameters.get(pe.getId());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLeftPrimaryExpression(PrimaryExpression left, Expression.Operator operator, Expression right, QueryData qd) {
        void var6_11;
        Query.FilterOperator op = DATANUCLEUS_OP_TO_APPENGINE_OP.get(operator);
        if (op == null) {
            throw new UnsupportedDatastoreFeatureException("Operator " + operator + " does not have a " + "corresponding operator in the datastore api.", this.query.getSingleStringQuery());
        }
        if (right instanceof PrimaryExpression) {
            Object v = qd.parameters.get(((PrimaryExpression)right).getId());
        } else if (right instanceof Literal) {
            Object object = ((Literal)right).getLiteral();
        } else if (right instanceof ParameterExpression) {
            Object object = this.getParameterValue(qd, (ParameterExpression)right);
        } else if (right instanceof DyadicExpression) {
            DyadicExpression dyadic = (DyadicExpression)right;
            if (!(dyadic.getLeft() instanceof Literal) || !(((Literal)dyadic.getLeft()).getLiteral() instanceof Number) || dyadic.getRight() != null || !Expression.OP_NEG.equals(dyadic.getOperator())) throw new UnsupportedDatastoreFeatureException("Right side of expression is composed of unsupported components.  Left: " + dyadic.getLeft().getClass().getName() + ", Op: " + dyadic.getOperator() + ", Right: " + dyadic.getRight(), this.query.getSingleStringQuery());
            Number negateMe = (Number)((Literal)dyadic.getLeft()).getLiteral();
            Object object = this.negateNumber(negateMe);
        } else {
            if (!(right instanceof InvokeExpression)) throw new UnsupportedDatastoreFeatureException("Right side of expression is of unexpected type: " + right.getClass().getName(), this.query.getSingleStringQuery());
            InvokeExpression invoke = (InvokeExpression)right;
            if (!invoke.getOperation().equals("CURRENT_TIMESTAMP") && !invoke.getOperation().equals("CURRENT_DATE")) throw this.newUnsupportedQueryMethodException((InvokeExpression)right);
            Date date = NOW_PROVIDER.now();
        }
        if (operator.equals(Expression.OP_NOTEQ) && var6_11 != null) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), (Expression.Operator)Expression.OP_NOTEQ, "The 'not equal' operator is only supported when the operator argument is 'null'");
        }
        List<String> tuples = this.getTuples(left, qd.compilation.getCandidateAlias());
        AbstractMemberMetaData ammd = this.getMemberMetaData(qd.acmd, tuples);
        if (ammd == null) {
            throw this.noMetaDataException(left.getId(), qd.acmd.getFullClassName());
        }
        JavaTypeMapping mapping = this.getMappingForFieldWithName(tuples, qd);
        if (mapping instanceof PersistenceCapableMapping) {
            this.processPersistenceCapableMapping(qd, op, ammd, var6_11);
            return;
        } else if (this.isParentPK(ammd)) {
            this.addParentFilter(op, this.internalPkToKey(qd.acmd, var6_11), qd);
            return;
        } else {
            void var6_13;
            String datastorePropName;
            if (ammd.isPrimaryKey()) {
                if (var6_11 instanceof Collection) {
                    if (!qd.datastoreQuery.getFilterPredicates().isEmpty()) {
                        this.throwInvalidBatchLookupException();
                    } else if (!op.equals((Object)Query.FilterOperator.EQUAL)) {
                        throw new NucleusUserException("Batch lookup by primary key is only supported with the equality operator.").setFatal();
                    }
                    qd.batchGetKeys = Utils.newHashSet(new Object[0]);
                    for (Object obj : (Collection)var6_11) {
                        qd.batchGetKeys.add(this.internalPkToKey(qd.acmd, obj));
                    }
                    return;
                }
                datastorePropName = "__key__";
                Key key = this.internalPkToKey(qd.acmd, var6_11);
            } else {
                datastorePropName = this.determinePropertyName(ammd);
            }
            if (var6_13 instanceof Collection) {
                throw new NucleusUserException("Collection parameters are only supported when filtering on primary key.").setFatal();
            }
            if (qd.batchGetKeys != null) {
                this.throwInvalidBatchLookupException();
            }
            Object object = this.pojoParamToDatastoreParam(var6_13);
            qd.datastoreQuery.addFilter(datastorePropName, op, object);
        }
    }

    private void throwInvalidBatchLookupException() {
        throw new NucleusUserException("Batch lookup by primary key is only supported if no other filters are defined.").setFatal();
    }

    private List<String> getTuples(PrimaryExpression expr, String alias) {
        List tuples = expr.getTuples();
        if (alias != null && tuples.size() > 1 && alias.equals(tuples.get(0))) {
            tuples = tuples.subList(1, tuples.size());
        }
        return tuples;
    }

    private Object pojoParamToDatastoreParam(Object param) {
        if (param instanceof Enum) {
            param = ((Enum)param).name();
        } else if (param instanceof byte[]) {
            param = new ShortBlob((byte[])param);
        } else if (param instanceof Byte[]) {
            param = new ShortBlob(PrimitiveArrays.toByteArray(Arrays.asList((Byte[])param)));
        } else if (param instanceof BigDecimal) {
            param = ((BigDecimal)param).doubleValue();
        } else if (param instanceof Character) {
            param = param.toString();
        }
        return param;
    }

    private NucleusException noMetaDataException(String member, String fullClassName) {
        return new NucleusUserException("No meta-data for member named " + member + " on class " + fullClassName + ".  Are you sure you provided the correct member name in your query?").setFatal();
    }

    private Object negateNumber(Number negateMe) {
        if (negateMe instanceof BigDecimal) {
            return ((BigDecimal)negateMe).negate().doubleValue();
        }
        if (negateMe instanceof Float) {
            return Float.valueOf(-((Float)negateMe).floatValue());
        }
        if (negateMe instanceof Double) {
            return -((Double)negateMe).doubleValue();
        }
        return -negateMe.longValue();
    }

    private JavaTypeMapping getMappingForFieldWithName(List<String> tuples, QueryData qd) {
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        AbstractClassMetaData acmd = qd.acmd;
        JavaTypeMapping mapping = null;
        for (String tuple : tuples) {
            DatastoreTable table = (DatastoreTable)qd.tableMap.get(acmd.getFullClassName());
            if (table == null) {
                table = this.getStoreManager().getDatastoreClass(acmd.getFullClassName(), clr);
                qd.tableMap.put(acmd.getFullClassName(), table);
            }
            mapping = table.getMemberMapping(tuple);
            acmd = this.getMetaDataManager().getMetaDataForClass(mapping.getMemberMetaData().getType(), clr);
        }
        return mapping;
    }

    private AbstractMemberMetaData getMemberMetaData(AbstractClassMetaData acmd, List<String> tuples) {
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(tuples.get(0));
        if (tuples.size() == 1) {
            return ammd;
        }
        EmbeddedMetaData emd = ammd.getEmbeddedMetaData();
        for (String tuple : tuples.subList(1, tuples.size())) {
            if (emd == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Can only filter by properties of a sub-object if " + "the sub-object is embedded.").setFatal();
            }
            ammd = this.findMemberMetaDataWithName(tuple, emd.getMemberMetaData());
        }
        return ammd;
    }

    private AbstractMemberMetaData findMemberMetaDataWithName(String name, AbstractMemberMetaData[] ammdList) {
        for (AbstractMemberMetaData embedded : ammdList) {
            if (!embedded.getName().equals(name)) continue;
            return embedded;
        }
        return null;
    }

    private void processPersistenceCapableMapping(QueryData qd, Query.FilterOperator op, AbstractMemberMetaData ammd, Object value) {
        Object jdoPrimaryKey;
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(ammd.getType(), clr);
        if (value instanceof Key || value instanceof String) {
            jdoPrimaryKey = value;
        } else if (value instanceof Long || value instanceof Integer) {
            String kind = EntityUtils.determineKind(acmd, this.getObjectManager());
            jdoPrimaryKey = KeyFactory.createKey((String)kind, (long)((Number)value).longValue());
        } else if (value == null) {
            jdoPrimaryKey = null;
        } else {
            ApiAdapter apiAdapter = this.getObjectManager().getApiAdapter();
            jdoPrimaryKey = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(value));
            if (jdoPrimaryKey == null) {
                StateManager sm = apiAdapter.newStateManager(this.getObjectManager(), acmd);
                sm.initialiseForHollow(null, null, value.getClass());
                sm.copyFieldsFromObject((PersistenceCapable)value, acmd.getPKMemberPositions());
                jdoPrimaryKey = sm.provideField(acmd.getPKMemberPositions()[0]);
            }
            if (jdoPrimaryKey == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Parameter value " + value + " does not have an id.").setFatal();
            }
        }
        Key valueKey = null;
        if (jdoPrimaryKey != null) {
            valueKey = this.internalPkToKey(qd.acmd, jdoPrimaryKey);
            this.verifyRelatedKeyIsOfProperType(ammd, valueKey, acmd);
        }
        if (!((DatastoreTable)qd.tableMap.get(ammd.getAbstractClassMetaData().getFullClassName())).isParentKeyProvider(ammd)) {
            if (op != Query.FilterOperator.EQUAL) {
                throw new UnsupportedDatastoreFeatureException("Only the equals operator is supported on conditions involving the owning side of a one-to-one.", this.query.getSingleStringQuery());
            }
            if (valueKey == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Cannot query for parents with null children.").setFatal();
            }
            if (valueKey.getParent() == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Key of parameter value does not have a parent.").setFatal();
            }
            qd.datastoreQuery.addFilter("__key__", Query.FilterOperator.EQUAL, (Object)valueKey.getParent());
        } else {
            if (valueKey == null) {
                throw new NucleusUserException(this.query.getSingleStringQuery() + ": Cannot query for objects with null parents.").setFatal();
            }
            this.addParentFilter(op, valueKey, qd);
        }
    }

    private void verifyRelatedKeyIsOfProperType(AbstractMemberMetaData ammd, Key key, AbstractClassMetaData acmd) {
        String fieldKind;
        String keyKind = key.getKind();
        if (!keyKind.equals(fieldKind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName())) {
            throw new NucleusUserException(this.query.getSingleStringQuery() + ": Field " + ammd.getFullFieldName() + " maps to kind " + fieldKind + " but" + " parameter value contains Key of kind " + keyKind).setFatal();
        }
    }

    private String determinePropertyName(AbstractMemberMetaData ammd) {
        if (ammd.getColumn() != null) {
            return ammd.getColumn();
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length != 0) {
            return ammd.getColumnMetaData()[0].getName();
        }
        return this.getIdentifierFactory().newDatastoreFieldIdentifier(ammd.getName()).getIdentifierName();
    }

    private Key internalPkToKey(AbstractClassMetaData acmd, Object internalPk) {
        Key key;
        if (internalPk instanceof String) {
            try {
                key = KeyFactory.stringToKey((String)((String)internalPk));
            }
            catch (IllegalArgumentException iae) {
                String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
                key = KeyFactory.createKey((String)kind, (String)((String)internalPk));
            }
        } else if (internalPk instanceof Long) {
            String kind = this.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
            key = KeyFactory.createKey((String)kind, (long)((Long)internalPk));
        } else {
            key = (Key)internalPk;
        }
        return key;
    }

    private void addParentFilter(Query.FilterOperator op, Key key, QueryData qd) {
        if (op != Query.FilterOperator.EQUAL) {
            throw new UnsupportedDatastoreFeatureException("Operator is of type " + op + " but the " + "datastore only supports parent queries using the equality operator.", this.query.getSingleStringQuery());
        }
        if (key == null) {
            throw new UnsupportedDatastoreFeatureException("Received a null parent parameter.  The datastore does not support querying for null parents.", this.query.getSingleStringQuery());
        }
        qd.datastoreQuery.setAncestor(key);
    }

    private void checkForUnsupportedOperator(Expression.Operator operator) {
        if (UNSUPPORTED_OPERATORS.contains(operator)) {
            throw new UnsupportedDatastoreOperatorException(this.query.getSingleStringQuery(), operator);
        }
    }

    private boolean isParentPK(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.parent-pk");
    }

    com.google.appengine.api.datastore.Query getLatestDatastoreQuery() {
        return this.latestDatastoreQuery;
    }

    private ObjectManager getObjectManager() {
        return this.query.getObjectManager();
    }

    private DatastoreManager getDatastoreManager() {
        return (DatastoreManager)this.getObjectManager().getStoreManager();
    }

    private MetaDataManager getMetaDataManager() {
        return this.getObjectManager().getMetaDataManager();
    }

    public static interface NowProvider {
        public Date now();
    }

    static class UnsupportedDatastoreFeatureException
    extends UnsupportedOperationException {
        UnsupportedDatastoreFeatureException(String msg, String queryString) {
            super("Problem with query <" + queryString + ">: " + msg);
        }
    }

    static class UnsupportedDatastoreOperatorException
    extends UnsupportedOperationException {
        private final String queryString;
        private final Expression.Operator operator;
        private final String msg;

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator) {
            this(queryString, operator, null);
        }

        UnsupportedDatastoreOperatorException(String queryString, Expression.Operator operator, String msg) {
            super(queryString);
            this.queryString = queryString;
            this.operator = operator;
            this.msg = msg;
        }

        public String getMessage() {
            return "Problem with query <" + this.queryString + ">: App Engine datastore does not support operator " + this.operator;
        }

        public Expression.Operator getOperation() {
            return this.operator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryData {
        private final Map parameters;
        private final AbstractClassMetaData acmd;
        private final Map<String, DatastoreTable> tableMap = Utils.newHashMap();
        private final QueryCompilation compilation;
        private final com.google.appengine.api.datastore.Query datastoreQuery;
        private final ResultType resultType;
        private final Utils.Function<Entity, Object> resultTransformer;
        private Set<Key> batchGetKeys;

        private QueryData(Map parameters, AbstractClassMetaData acmd, DatastoreTable table, QueryCompilation compilation, com.google.appengine.api.datastore.Query datastoreQuery, ResultType resultType, Utils.Function<Entity, Object> resultTransformer) {
            this.parameters = parameters;
            this.acmd = acmd;
            this.tableMap.put(acmd.getFullClassName(), table);
            this.compilation = compilation;
            this.datastoreQuery = datastoreQuery;
            this.resultType = resultType;
            this.resultTransformer = resultTransformer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResultType {
        ENTITY,
        ENTITY_PROJECTION,
        COUNT,
        KEYS_ONLY;

    }
}

