/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultsSourceImpl
implements QueryResultsSource {
    static Logger logger = Logger.getLogger(QueryResultsSourceImpl.class.getName());
    private static final int AT_LEAST_ONE = -1;
    private static final String DISABLE_CHUNK_SIZE_WARNING_SYS_PROP = "appengine.datastore.disableChunkSizeWarning";
    private static final int CHUNK_SIZE_WARNING_RESULT_SET_SIZE_THRESHOLD = 1000;
    private static final long MAX_CHUNK_SIZE_WARNING_FREQUENCY_MS = 300000L;
    static final AtomicLong lastChunkSizeWarning = new AtomicLong(0L);
    private final ApiProxy.ApiConfig apiConfig;
    private final int chunkSize;
    private final int offset;
    private final Transaction txn;
    private Future<DatastorePb.QueryResult> nextResult;
    private int skippedResults;
    private int totalResults = 0;

    public QueryResultsSourceImpl(ApiProxy.ApiConfig apiConfig, FetchOptions fetchOptions, Transaction txn, Future<DatastorePb.QueryResult> firstResult) {
        this.apiConfig = apiConfig;
        this.chunkSize = fetchOptions.getChunkSize() != null ? fetchOptions.getChunkSize() : -1;
        this.offset = fetchOptions.getOffset() != null ? fetchOptions.getOffset() : 0;
        this.txn = txn;
        this.nextResult = firstResult;
        this.skippedResults = 0;
    }

    @Override
    public boolean hasMoreEntities() {
        return this.nextResult != null;
    }

    @Override
    public int getNumSkipped() {
        return this.skippedResults;
    }

    @Override
    public Cursor loadMoreEntities(List<Entity> buffer) {
        return this.loadMoreEntities(-1, buffer);
    }

    @Override
    public Cursor loadMoreEntities(int numberToLoad, List<Entity> buffer) {
        TransactionImpl.ensureTxnActive(this.txn);
        if (this.nextResult != null) {
            if (numberToLoad == 0 && this.offset <= this.skippedResults) {
                return null;
            }
            int previousSize = buffer.size();
            DatastorePb.QueryResult res = FutureHelper.quietGet(this.nextResult);
            this.nextResult = null;
            this.processQueryResult(res, buffer);
            if (res.isMoreResults()) {
                DatastorePb.NextRequest req = new DatastorePb.NextRequest();
                req.getMutableCursor().copyFrom(res.getCursor());
                if (res.hasCompiledCursor()) {
                    req.setCompile(true);
                }
                boolean setCount = true;
                if (numberToLoad <= 0) {
                    setCount = false;
                    if (this.chunkSize != -1) {
                        req.setCount(this.chunkSize);
                    }
                    if (numberToLoad == -1) {
                        numberToLoad = 1;
                    }
                }
                while ((this.skippedResults < this.offset || buffer.size() - previousSize < numberToLoad) && res.isMoreResults()) {
                    if (this.skippedResults < this.offset) {
                        req.setOffset(this.offset - this.skippedResults);
                    } else {
                        req.clearOffset();
                    }
                    if (setCount) {
                        req.setCount(Math.max(this.chunkSize, numberToLoad - buffer.size() + previousSize));
                    }
                    res = new DatastorePb.QueryResult();
                    DatastoreApiHelper.makeSyncCall(this.apiConfig, "Next", req, res);
                    this.processQueryResult(res, buffer);
                }
                if (res.isMoreResults()) {
                    if (this.chunkSize != -1) {
                        req.setCount(this.chunkSize);
                    } else {
                        req.clearCount();
                    }
                    req.clearOffset();
                    this.nextResult = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Next", req, new DatastorePb.QueryResult());
                }
            }
            return res.hasCompiledCursor() ? new Cursor(res.getCompiledCursor()) : null;
        }
        return null;
    }

    private void processQueryResult(DatastorePb.QueryResult res, List<Entity> buffer) {
        this.skippedResults += res.getSkippedResults();
        for (OnestoreEntity.EntityProto entityProto : res.results()) {
            buffer.add(EntityTranslator.createFromPb(entityProto));
        }
        this.totalResults += res.resultSize();
        if (this.chunkSize == -1 && this.totalResults > 1000 && System.getProperty(DISABLE_CHUNK_SIZE_WARNING_SYS_PROP) == null) {
            this.logChunkSizeWarning();
        }
    }

    void logChunkSizeWarning() {
        long now = System.currentTimeMillis();
        if (now - lastChunkSizeWarning.get() < 300000L) {
            return;
        }
        logger.warning("This query does not have a chunk size set in FetchOptions and has returned over 1000 results.  If result sets of this size are common for this query, consider setting a chunk size to improve performance.\n  To disable this warning set the following system property in appengine-web.xml (the value of the property doesn't matter): 'appengine.datastore.disableChunkSizeWarning'");
        lastChunkSizeWarning.set(now);
    }
}

