/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import java.util.Iterator;
import org.datanucleus.store.appengine.query.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlicingIterable<T>
implements Iterable<T> {
    private final int offset;
    private final Integer limit;
    private final Iterable<T> data;

    SlicingIterable(int offset, Integer limit, Iterable<T> data) {
        this.offset = offset;
        this.limit = limit;
        this.data = data;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            private int remainingOffset;
            private Integer numEntitiesReturned;
            private final Iterator<T> iter;
            {
                this.remainingOffset = SlicingIterable.this.offset;
                this.numEntitiesReturned = 0;
                this.iter = SlicingIterable.this.data.iterator();
            }

            @Override
            protected T computeNext() {
                if (this.numEntitiesReturned.equals(SlicingIterable.this.limit)) {
                    this.endOfData();
                }
                Object next = null;
                while (this.iter.hasNext() && this.remainingOffset-- >= 0) {
                    next = this.iter.next();
                }
                if (this.remainingOffset >= 0 || next == null) {
                    this.endOfData();
                }
                this.remainingOffset = 0;
                Integer n = this.numEntitiesReturned;
                Integer n2 = this.numEntitiesReturned = Integer.valueOf(this.numEntitiesReturned + 1);
                return next;
            }
        };
    }
}

