/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import java.util.Iterator;
import org.datanucleus.store.appengine.DatastoreExceptionTranslator;
import org.datanucleus.store.appengine.query.RuntimeExceptionWrappingIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuntimeExceptionWrappingIterable
implements Iterable<Entity> {
    private final Iterable<Entity> inner;

    RuntimeExceptionWrappingIterable(Iterable<Entity> inner) {
        this.inner = inner;
    }

    @Override
    public Iterator<Entity> iterator() {
        try {
            return this.newIterator(this.inner.iterator());
        }
        catch (IllegalArgumentException e) {
            throw DatastoreExceptionTranslator.wrapIllegalArgumentException(e);
        }
        catch (DatastoreTimeoutException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreTimeoutExceptionForQuery(e);
        }
        catch (DatastoreFailureException e) {
            throw DatastoreExceptionTranslator.wrapDatastoreFailureException(e);
        }
    }

    Iterator<Entity> newIterator(Iterator<Entity> innerIter) {
        return new RuntimeExceptionWrappingIterator(innerIter);
    }
}

