/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataValidator {
    private static final Set<String> ONE_OR_ZERO_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.encoded-pk", "gae.pk-name", "gae.parent-pk");
    private static final Set<String> NOT_PRIMARY_KEY_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.pk-name", "gae.parent-pk");
    private static final Set<String> REQUIRES_ENCODED_STRING_PK_EXTENSIONS = Utils.newHashSet("gae.pk-id", "gae.pk-name");
    private static final String IGNORABLE_META_DATA_BEHAVIOR_PROPERTY = "datanucleus.appengine.ignorableMetaDataBehavior";
    static final String ADJUST_WARNING_MSG = String.format("You can modify this warning by setting the %s property in your config.  A value of %s will silence the warning.  A value of %s will turn the warning into an exception.", new Object[]{"datanucleus.appengine.ignorableMetaDataBehavior", IgnorableMetaDataBehavior.NONE, IgnorableMetaDataBehavior.ERROR});
    private static final Set<Integer> NON_REPEATABLE_RELATION_TYPES = Utils.newHashSet(4, 3, 2, 1);
    private static final String ALLOW_MULTIPLE_RELATIONS_OF_SAME_TYPE = "datanucleus.appengine.allowMultipleRelationsOfSameType";
    private final AbstractClassMetaData acmd;
    private final MetaDataManager metaDataManager;
    private final ClassLoaderResolver clr;
    private boolean noParentAllowed = false;

    public MetaDataValidator(AbstractClassMetaData acmd, MetaDataManager metaDataManager, ClassLoaderResolver clr) {
        this.acmd = acmd;
        this.metaDataManager = metaDataManager;
        this.clr = clr;
    }

    public void validate() {
        NucleusLogger.METADATA.info((Object)("Performing appengine-specific metadata validation for " + this.acmd.getFullClassName()));
        AbstractMemberMetaData pkMemberMetaData = this.validatePrimaryKey();
        this.validateFields(pkMemberMetaData);
        this.validateClass();
        NucleusLogger.METADATA.info((Object)("Finished performing appengine-specific metadata validation for " + this.acmd.getFullClassName()));
    }

    private void validateClass() {
        if (this.acmd.getUniqueMetaData() != null && this.acmd.getUniqueMetaData().length > 0) {
            this.handleIgnorableMapping("The datastore does not support uniqueness constraints.", "The constraint definition will be ignored.");
        }
    }

    private void validateFields(AbstractMemberMetaData pkMemberMetaData) {
        HashSet<Object> foundOneOrZeroExtensions = Utils.newHashSet(new Object[0]);
        HashMap<Class<?>, String> nonRepeatableRelationTypes = Utils.newHashMap();
        Class pkClass = pkMemberMetaData.getType();
        AbstractClassMetaData curCmd = this.acmd;
        do {
            for (AbstractMemberMetaData ammd : curCmd.getManagedMembers()) {
                this.validateField(pkMemberMetaData, pkClass, foundOneOrZeroExtensions, nonRepeatableRelationTypes, ammd);
            }
        } while ((curCmd = curCmd.getSuperAbstractClassMetaData()) != null);
    }

    private void validateField(AbstractMemberMetaData pkMemberMetaData, Class<?> pkClass, Set<String> foundOneOrZeroExtensions, Map<Class<?>, String> nonRepeatableRelationTypes, AbstractMemberMetaData ammd) {
        SequenceMetaData sequenceMetaData;
        for (String extension : ONE_OR_ZERO_EXTENSIONS) {
            if (!ammd.hasExtension(extension) || foundOneOrZeroExtensions.add(extension)) continue;
            throw new DatastoreMetaDataException(this.acmd, ammd, "Cannot have more than one field with the \"" + extension + "\" extension.");
        }
        if (!(!ammd.hasExtension("gae.encoded-pk") || ammd.isPrimaryKey() && ammd.getType().equals(String.class))) {
            throw new DatastoreMetaDataException(this.acmd, ammd, "A field with the \"gae.encoded-pk\" extension can only be applied to a String primary key.");
        }
        if (ammd.hasExtension("gae.pk-name") && !ammd.getType().equals(String.class)) {
            throw new DatastoreMetaDataException(this.acmd, ammd, "\"gae.pk-name\" can only be applied to a String field.");
        }
        if (ammd.hasExtension("gae.pk-id") && !ammd.getType().equals(Long.class)) {
            throw new DatastoreMetaDataException(this.acmd, ammd, "\"gae.pk-id\" can only be applied to a Long field.");
        }
        if (ammd.hasExtension("gae.parent-pk")) {
            if (this.noParentAllowed) {
                throw new DatastoreMetaDataException(this.acmd, ammd, "Cannot have a " + pkClass.getName() + " primary key and a parent pk field.");
            }
            if (!ammd.getType().equals(String.class) && !ammd.getType().equals(Key.class)) {
                throw new DatastoreMetaDataException(this.acmd, ammd, "Parent pk must be of type String or " + Key.class.getName() + ".");
            }
        }
        for (String extension : NOT_PRIMARY_KEY_EXTENSIONS) {
            if (!ammd.hasExtension(extension) || !ammd.isPrimaryKey()) continue;
            throw new DatastoreMetaDataException(this.acmd, ammd, "A field with the \"" + extension + "\" extension must not be the primary key.");
        }
        for (String extension : REQUIRES_ENCODED_STRING_PK_EXTENSIONS) {
            if (!ammd.hasExtension(extension) || pkMemberMetaData.hasExtension("gae.encoded-pk")) continue;
            throw new DatastoreMetaDataException(this.acmd, ammd, "A field with the \"" + extension + "\" extension can only be used in conjunction " + "with an encoded String primary key..");
        }
        if (this.noParentAllowed) {
            this.checkForIllegalChildField(ammd);
        }
        if (ammd.getRelationType(this.clr) != 0) {
            if (ammd.isDefaultFetchGroup() && !ammd.isEmbedded()) {
                String msg = this.isJPA() ? "The datastore does not support joins and therefore cannot honor requests to eagerly load child objects." : "The datastore does not support joins and therefore cannot honor requests to place child objects in the default fetch group.";
                this.handleIgnorableMapping(ammd, msg, "The field will be fetched lazily on first access.");
            }
            if (ammd.getRelationType(this.clr) == 5) {
                throw new DatastoreMetaDataException(this.acmd, ammd, "Many-to-many is not currently supported in App Engine.  As a workaround, consider maintaining a List<Key> on both sides of the relationship.  See http://code.google.com/appengine/docs/java/datastore/relationships.html#Unowned_Relationships for more information.");
            }
            if (ammd.getEmbeddedMetaData() == null && NON_REPEATABLE_RELATION_TYPES.contains(ammd.getRelationType(this.clr)) && !this.getBooleanConfigProperty(ALLOW_MULTIPLE_RELATIONS_OF_SAME_TYPE)) {
                Class relationClass = ammd.getCollection() != null ? this.clr.classForName(ammd.getCollection().getElementType()) : (ammd.getArray() != null ? this.clr.classForName(ammd.getArray().getElementType()) : this.clr.classForName(ammd.getTypeName()));
                for (Class<?> existingRelationClass : nonRepeatableRelationTypes.keySet()) {
                    if (!existingRelationClass.isAssignableFrom(relationClass) && !relationClass.isAssignableFrom(existingRelationClass)) continue;
                    throw this.newMultipleRelationshipFieldsOfSameType(ammd, relationClass, ammd.getName(), nonRepeatableRelationTypes.get(existingRelationClass));
                }
                nonRepeatableRelationTypes.put(relationClass, ammd.getName());
            }
        }
        if (ammd.getValueGeneratorName() != null && (sequenceMetaData = this.metaDataManager.getMetaDataForSequence(this.clr, ammd.getValueGeneratorName())) != null && sequenceMetaData.getInitialValue() != 1L) {
            this.handleIgnorableMapping(ammd, "The datastore does not support the configuration of initial sequence values.", "The first value for this sequence will be 1.");
        }
    }

    private DatastoreMetaDataException newMultipleRelationshipFieldsOfSameType(AbstractMemberMetaData ammd, Class<?> relationClass, String field1, String field2) {
        return new DatastoreMetaDataException(this.acmd, ammd, "Class " + this.acmd.getFullClassName() + " has multiple relationship fields of type " + relationClass.getName() + ": " + field1 + " and " + field2 + ".  This is not yet supported.");
    }

    boolean isJPA() {
        return DatastoreManager.isJPA(this.metaDataManager.getOMFContext());
    }

    private boolean getBooleanConfigProperty(String configProperty) {
        return this.metaDataManager.getOMFContext().getPersistenceConfiguration().getBooleanProperty(configProperty);
    }

    private IgnorableMetaDataBehavior getIgnorableMetaDataBehavior() {
        return IgnorableMetaDataBehavior.valueOf(this.metaDataManager.getOMFContext().getPersistenceConfiguration().getStringProperty(IGNORABLE_META_DATA_BEHAVIOR_PROPERTY), IgnorableMetaDataBehavior.WARN);
    }

    void handleIgnorableMapping(String msg, String warningOnlyMsg) {
        this.handleIgnorableMapping(null, msg, warningOnlyMsg);
    }

    void handleIgnorableMapping(AbstractMemberMetaData ammd, String msg, String warningOnlyMsg) {
        switch (this.getIgnorableMetaDataBehavior()) {
            case WARN: {
                if (ammd == null) {
                    this.warn(String.format("Meta-data warning for %s: %s  %s  %s", this.acmd.getFullClassName(), msg, warningOnlyMsg, ADJUST_WARNING_MSG));
                    break;
                }
                this.warn(String.format("Meta-data warning for %s.%s: %s  %s  %s", this.acmd.getFullClassName(), ammd.getName(), msg, warningOnlyMsg, ADJUST_WARNING_MSG));
                break;
            }
            case ERROR: {
                if (ammd == null) {
                    throw new DatastoreMetaDataException(this.acmd, msg);
                }
                throw new DatastoreMetaDataException(this.acmd, ammd, msg);
            }
        }
    }

    void warn(String msg) {
        NucleusLogger.METADATA.warn((Object)msg);
    }

    private void checkForIllegalChildField(AbstractMemberMetaData ammd) {
        int relationType = ammd.getRelationType(this.clr);
        if (relationType == 0 || ammd.isEmbedded()) {
            return;
        }
        AbstractClassMetaData childAcmd = null;
        if (relationType == 4 || relationType == 3) {
            if (ammd.getCollection() != null) {
                childAcmd = ammd.getCollection().getElementClassMetaData(this.clr);
            } else if (ammd.getArray() != null) {
                childAcmd = ammd.getArray().getElementClassMetaData(this.clr);
            } else {
                NucleusLogger.METADATA.warn((Object)("Unable to validate one-to-many relation " + ammd.getFullFieldName()));
            }
        } else if (relationType == 2 || relationType == 1) {
            childAcmd = this.metaDataManager.getMetaDataForClass(ammd.getType(), this.clr);
        }
        if (childAcmd == null) {
            return;
        }
        int[] pkPositions = childAcmd.getPKMemberPositions();
        if (pkPositions == null) {
            NucleusLogger.METADATA.warn((Object)("Unable to validate relation " + ammd.getFullFieldName()));
            return;
        }
        int pkPos = pkPositions[0];
        AbstractMemberMetaData pkMemberMetaData = childAcmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPos);
        Class pkType = pkMemberMetaData.getType();
        if (pkType.equals(Long.class) || pkType.equals(String.class) && !pkMemberMetaData.hasExtension("gae.encoded-pk")) {
            throw new DatastoreMetaDataException(childAcmd, pkMemberMetaData, "Cannot have a " + pkType.getName() + " primary key and be a child object " + "(owning field is " + ammd.getFullFieldName() + ").");
        }
    }

    private AbstractMemberMetaData validatePrimaryKey() {
        int[] pkPositions = this.acmd.getPKMemberPositions();
        if (pkPositions == null) {
            throw new DatastoreMetaDataException(this.acmd, "No primary key defined.");
        }
        if (pkPositions.length != 1) {
            throw new DatastoreMetaDataException(this.acmd, "More than one primary key field.");
        }
        int pkPos = pkPositions[0];
        AbstractMemberMetaData pkMemberMetaData = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPos);
        Class pkType = pkMemberMetaData.getType();
        if (pkType.equals(Long.class)) {
            this.noParentAllowed = true;
        } else if (pkType.equals(String.class)) {
            if (!DatastoreManager.isEncodedPKField(this.acmd, pkPos)) {
                this.noParentAllowed = true;
            } else if (MetaDataValidator.hasIdentityStrategy(IdentityStrategy.SEQUENCE, pkMemberMetaData)) {
                throw new DatastoreMetaDataException(this.acmd, pkMemberMetaData, "IdentityStrategy SEQUENCE is not supported on encoded String primary keys.");
            }
        } else if (pkType.equals(Key.class)) {
            if (MetaDataValidator.hasIdentityStrategy(IdentityStrategy.SEQUENCE, pkMemberMetaData)) {
                throw new DatastoreMetaDataException(this.acmd, pkMemberMetaData, "IdentityStrategy SEQUENCE is not supported on primary keys of type " + Key.class.getName());
            }
        } else {
            throw new DatastoreMetaDataException(this.acmd, pkMemberMetaData, "Unsupported primary key type: " + pkType.getName());
        }
        return pkMemberMetaData;
    }

    private static boolean hasIdentityStrategy(IdentityStrategy strat, AbstractMemberMetaData ammd) {
        return ammd.getValueStrategy() != null && ammd.getValueStrategy().equals((Object)strat);
    }

    static final class DatastoreMetaDataException
    extends NucleusUserException {
        private static final String MSG_FORMAT_CLASS_ONLY = "Error in meta-data for %s: %s";
        private static final String MSG_FORMAT = "Error in meta-data for %s.%s: %s";

        private DatastoreMetaDataException(AbstractClassMetaData acmd, String msg) {
            super(String.format(MSG_FORMAT_CLASS_ONLY, acmd.getFullClassName(), msg));
        }

        private DatastoreMetaDataException(AbstractClassMetaData acmd, AbstractMemberMetaData ammd, String msg) {
            super(String.format(MSG_FORMAT, acmd.getFullClassName(), ammd.getName(), msg));
        }

        public boolean isFatal() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IgnorableMetaDataBehavior {
        NONE,
        WARN,
        ERROR;


        private static IgnorableMetaDataBehavior valueOf(String val, IgnorableMetaDataBehavior returnIfNull) {
            if (val == null) {
                return returnIfNull;
            }
            return IgnorableMetaDataBehavior.valueOf(val);
        }
    }
}

