/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Entity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.DatastoreQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionResultTransformer
implements Utils.Function<Entity, Object> {
    private final Utils.Function<Entity, Object> entityToPojoFunc;
    private final ObjectManager objectManager;
    private final Iterable<AbstractMemberMetaData> projectionFields;
    private final String queryString;

    ProjectionResultTransformer(Utils.Function<Entity, Object> entityToPojoFunc, ObjectManager objectManager, Iterable<AbstractMemberMetaData> projectionFields, String queryString) {
        this.entityToPojoFunc = entityToPojoFunc;
        this.objectManager = objectManager;
        this.projectionFields = projectionFields;
        this.queryString = queryString;
    }

    @Override
    public Object apply(Entity from) {
        PersistenceCapable pc = (PersistenceCapable)this.entityToPojoFunc.apply(from);
        StateManager sm = this.objectManager.findStateManager((Object)pc);
        ArrayList<Object> values = Utils.newArrayList(new Object[0]);
        Iterator<AbstractMemberMetaData> i$ = this.projectionFields.iterator();
        while (i$.hasNext()) {
            AbstractMemberMetaData ammd;
            AbstractMemberMetaData curMetaData = ammd = i$.next();
            LinkedList<Object> embeddedFieldNames = Utils.newLinkedList(new Object[0]);
            while (curMetaData.getParent() instanceof EmbeddedMetaData) {
                if (!(curMetaData.getParent().getParent() instanceof AbstractMemberMetaData)) {
                    throw new DatastoreQuery.UnsupportedDatastoreFeatureException("Unexpected metadata while parsing result expression with embedded fields: " + curMetaData, this.queryString);
                }
                embeddedFieldNames.add(curMetaData.getName());
                curMetaData = (AbstractMemberMetaData)curMetaData.getParent().getParent();
            }
            Object curValue = sm.provideField(curMetaData.getAbsoluteFieldNumber());
            while (!embeddedFieldNames.isEmpty()) {
                StateManager embeddedSm = this.objectManager.findStateManager(curValue);
                AbstractClassMetaData embeddedClassMetaData = embeddedSm.getClassMetaData();
                AbstractMemberMetaData embeddedField = embeddedClassMetaData.getMetaDataForMember((String)embeddedFieldNames.removeFirst());
                curValue = embeddedSm.provideField(embeddedField.getAbsoluteFieldNumber());
            }
            values.add(curValue);
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return values.toArray(new Object[values.size()]);
    }
}

