import os, json
from google.cloud import pubsub_v1 # google-cloud-pubsub==2.8.0

def http_to_pubsub(request):
    request_json = request.get_json()
    request_args = request.args

    print('Żądanie json: {}'.format(request_json))

    if request_json:
        res = trigger(json.dumps(request_json).encode('utf-8'), request.path)
        return res
    else:
        return 'Nie znaleziono danych', 204


def trigger(data, topic_name):
  publisher = pubsub_v1.PublisherClient()

  topic_name = 'projects/{project_id}/topics{topic}'.format(
    project_id=os.getenv('GCP_PROJECT'),
    topic=topic_name,
  )

  print ('Publikowanie komunikatu w temacie {}'.format(topic_name))
  
  # Tworzenie tematu, jeśli jest to wymagane
  try:
    future = publisher.publish(topic_name, data)
    future_return = future.result()
    print('Opublikowano temat {}'.format(future_return))

    return future_return

  except Exception as e:
    print('Temat {} nie istnieje? Próba jego utworzenia'.format(topic_name))
    print('Błąd: {}'.format(e))

    publisher.create_topic(name=topic_name)
    print ('Utworzono temat ' + topic_name)

    return 'Utworzono temat', 201