"""Aplikacja Streamlit app do analizy danych.

Uruchom w ten sposób:
> PYTHONPATH=. streamlit run data_science/indexing.py
"""
import streamlit as st

from data_science.agent import query_agent, create_agent


st.title("👨‍💻 Czatuj ze swoim plikiem CSV")

st.write("Wczytaj poniżej swój plik CSV.")

data_file = st.file_uploader("Wczytaj plik CSV")

query = st.text_area("Wpisz pytanie")

if st.button("Submit Query", type="primary"):
    assert data_file is not None
    agent = create_agent(data_file)
    response = query_agent(agent=agent, query=query)
    st.write(response)
