from langchain import PromptTemplate
from langchain.chains import SequentialChain
from langchain.chains.llm import LLMChain
from langchain.chat_models import ChatOpenAI
from config import set_environment

set_environment()


solutions_template = """
Wygeneruj {num_solutions} różnych rozwiązań dla {problem}. Uwzględnij takie czynniki jak {factors}.

Rozwiązania:
"""
solutions_prompt = PromptTemplate(
   template=solutions_template,
   input_variables=["problem", "factors", "num_solutions"]
)
evaluation_template = """
Oceń każde rozwiązanie z {solutions} poprzez analizę zalet i wad, wykonalności oraz prawdopodobieństwo powodzenia.

Ocena:
"""
evaluation_prompt = PromptTemplate(
  template=evaluation_template,
  input_variables=["solutions"]
)
reasoning_template = """
Dla najbardziej obiecujących rozwiązań z {evaluations} wyjaśnij scenariusz, strategie implementacji, potrzeby partnerów oraz obsługę potencjalnych przeszkód. 

Poszerzone rozumowanie: 
"""
reasoning_prompt = PromptTemplate(
  template=reasoning_template,
  input_variables=["evaluations"]
)
ranking_template = """
Na podstawie ocen i rozumowania, utwórz ranking rozwiązań z {enhanced_reasoning} od najbardziej do najmniej obiecującego.

Ranking rozwiązań:
"""
ranking_prompt = PromptTemplate(
  template=ranking_template,
  input_variables=["enhanced_reasoning"]
)

solutions_chain = LLMChain(
   llm=ChatOpenAI(),
   prompt=solutions_prompt,
   output_key="solutions"
)
evalutation_chain = LLMChain(
   llm=ChatOpenAI(),
   prompt=evaluation_prompt,
   output_key="evaluations"
)
reasoning_chain = LLMChain(
   llm=ChatOpenAI(),
   prompt=reasoning_prompt,
   output_key="enhanced_reasoning"
)
ranking_chain = LLMChain(
   llm=ChatOpenAI(),
   prompt=ranking_prompt,
   output_key="ranked_solutions"
)
tot_chain = SequentialChain(
   chains=[solutions_chain, evalutation_chain, reasoning_chain, ranking_chain],
   input_variables=["problem", "factors", "num_solutions"],
   output_variables=["ranked_solutions"]
)
print(tot_chain.run(
   problem="Inżynieria podpowiedzi",
   factors="Wymagana wysoka wydajność wykonywania zadań, niskie zużycie tokenów oraz mała liczba wywołań dużego modelu językowego",
   num_solutions=3
))


if __name__ == "__main__":
    pass
