"""Oceń wynik zwrócone przez agenta

poprzez obliczenie odelgłości osadzeń do oczekiwanego rezultatu (odwołania).
"""
from langchain.evaluation import load_evaluator, EvaluatorType, PairwiseStringEvalChain
from config import set_environment

set_environment()
# evaluator = load_evaluator("embedding_distance")
#
# print(evaluator.evaluate_strings(prediction="I shall go", reference="I shan't go"))
#
#
# evaluator = load_evaluator("labeled_pairwise_string")
#
# print(evaluator.evaluate_string_pairs(
#     prediction="there are three dogs",
#     prediction_b="4",
#     input="how many dogs are in the park?",
#     reference="four",
# ))

custom_criteria = {
    "simplicity": "Czy język jest prosty i bezpretensjonalny?",
    "clarity": "Czy zdania są jasne i łatwe do zrozumienia?",
    "precision": "Czy pisanie jest precyzyjne, bez zbędnych słów lub szczegółów?",
    "truthfulness": "Czy pisanie wydaje się uczciwe i szczere?",
    "subtext": "Czy tekst sugeruje głębsze znaczenia lub motywy?",
}
evaluator = load_evaluator(EvaluatorType.PAIRWISE_STRING, criteria=custom_criteria)

assert isinstance(evaluator, PairwiseStringEvalChain)
print(evaluator.evaluate_string_pairs(
    prediction="Każde pogodne gospodarstwo domowe ma podobny rytm radości; ale żal w każdym gospodarstwie gra unikatową, przejmującą melodię.",
    prediction_b="Gdzie znajduje się symfonia radości, każde domostwo szczęścia rozbrzmiewa w harmonii,"
    " identyczne nuty; jednak każdy dom rozpaczy prowadzi dysonansową orkiestrę"
    " każda z nich grająca elegię żalu, która jest swoista i głęboka dla własnego istnienia.",
    input="Napisz prozę o rodzinach.",
))


if __name__ == "__main__":
    pass

